<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\SurgeryType;


class SurgeryTypesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $surgery_types = SurgeryType::select(
            'surgery_types.id as id',
            'surgery_types.name as name',
            'surgery_types.code as code',
            'surgery_types.code as details',
            'surgery_types.status as status' ,
            'surgery_types.priority as priority' ,
        )->orderBy('surgery_types.priority', 'ASC');

        if ($request->ajax()) {
            $sort_by      = $request->get('sortby') ?? 10;
            $sort_type    = $request->get('sorttype');
            $search_query = $request->get('query');

            $surgery_types = $surgery_types->when(!empty($search_query), function ($query) use ($search_query) {
                return $query->where('surgery_types.name', 'like', '%'.$search_query.'%')
                ->orWhere('surgery_types.code', 'like', '%'.$search_query.'%')
                ->orWhere('surgery_types.details', 'like', '%'.$search_query.'%');
            })->paginate($sort_by);

            return view('surgery-types.table', compact('surgery_types'));
        } else {
            $surgery_types = $surgery_types->paginate(10);

            return view('surgery-types.index', compact('surgery_types'));
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        //
    }



    public function createSurgeryType()
    {
       $surgery_types = SurgeryType::select(
            'surgery_types.name as name',
            'surgery_types.code as code',
            'surgery_types.code as details',
            'surgery_types.code as priority',
        )->get();

        $priority = SurgeryType::max('priority');
        
        return view('accounts.create-surgery-types', compact('surgery_types' , 'priority'));
    } 

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        //
    }


      public function storeSurgeryType(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'name'     => 'required',
            'code'     => 'required',
            'details'  => 'required',
            'priority' => 'required',
        ]);

        if ($validator->fails()) {

            return response()->json([
                'success'  => true,
                'message'  => $validator->getMessageBag()->first(),
                'data'     => [
                'redirect' => 'surgery-types.index'],
            ]);
        }

        $surgery_type = SurgeryType::create([
            'name'     => $request->name,
            'code'     => $request->code,
            'details'  => $request->details,
            'priority' => $request->priority,
        ]);

        return response()->json([
            'success'  => true,
            'message'  => 'Surgery Type Created successfully',
            'data'     => [
            'redirect' => 'surgery-types.index', 
            ]
        ]);
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
         $surgery_type = SurgeryType::findOrFail($id);

        return view('accounts.edit-surgery-types', compact('surgery_type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        //
    }

    public function updateSurgeryType(Request $request, $id)
    {
        $validator = \Validator::make($request->all(), [
            'name'     => 'required',
            'code'     => 'required',
            'details'  => 'required',
            'priority' => 'required',
        ]);

        if ($validator->fails()) {
           return response()->json([
                'success'  => true,
                'message'  => $validator->getMessageBag()->first(),
                'data'     => [
                'redirect' => 'surgery-types.index'],
            ]);
        }

        $surgery_type = SurgeryType::findOrFail($id);
        $surgery_type->update($request->all());

        return response()->json([
            'success'  => true,
            'message'  => 'Surgery Type Created successfully',
            'data'     => [
            'redirect' => 'surgery-types.index', 
            ]
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $surgery_types = SurgeryType::findOrFail($id);
        $surgery_types->delete();

        return response()->json([
            'success' => true,
            'message' => 'Surgery Type Deleted successfully',
            'data' => [
                'redirect' => '', 
            ]
        ]);
    }


     public function changeStatus(Request $request)
    {
        if ($request->ajax()) {
            $data   = array('status' => $request->status );
            $update = SurgeryType::where('id', '=', $request->id)->update($data);

            if($update){
                return response()->json([
                    'success'=>true,
                    'message'=>['Surgery Type status successfully change'],
                    'data'=>[
                       'redirect'=>'/users/',
                       'reload'=>true,
                    ]
                ]);
            } else {
                return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
                ]);
            }
        }
    }

}
