<?php

namespace App\Http\Controllers\TaxMaster;

use App\Http\Controllers\Controller;
use App\Models\MenuModelPermission;
use App\Models\TaxCalculation;
use App\Models\VoucherMaster;
use Illuminate\Http\Request;

class taxCalculationController extends Controller
{
    function __construct()
    {
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $data = TaxCalculation::select([
            'tax_calculations.id',
            'tax_calculations.voucher_master_id',
            'tax_calculations.calculation_type',
            'tax_calculations.description',
            'tax_calculations.status',
        ])
        ->with('getVoucher');

        if ($request->ajax()) {
            $sort_by      = $request->get('sortby') ?? 10;
            $sort_type    = $request->get('sorttype');
            $search_query = $request->get('query');

            $data = $data->when(!empty($search_query), function ($query) use ($search_query) {
                return $query->where('voucher_master_id', 'like', '%'.$search_query.'%');
            })
            ->paginate($sort_by);

            return view('tax-calculations.table', compact('data'));
        } else {
            $data = $data->paginate(10);

            return view('tax-calculations.index', compact('data'));
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $voucher = VoucherMaster::select('id','voucher_name')->get();

        return view('tax-calculations.create', compact('voucher'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'voucher_master_id'        => 'required|unique:tax_calculations,voucher_master_id,NULL,id,calculation_type,' . $request->calculation_type,
            'calculation_type' => 'required',
        ],[
            'voucher_master_id.required' => 'The module is required.',
            'voucher_master_id.unique'   => 'The module has already been taken for the selected calculation type.',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            '_method'
        ]);

        $quality = TaxCalculation::create($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Tax Calculation created successfully',
                'data'    => $quality
            ]);
        }

        return redirect()->route('tax-calculation.index')
            ->with('success', 'Tax Calculation created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $taxCalculation = TaxCalculation::find($id);
        $voucher = VoucherMaster::select('id','voucher_name')->get();

        return view('tax-calculations.edit', compact('taxCalculation', 'voucher'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = \Validator::make($request->all(), [
            'voucher_master_id'        => 'required|unique:tax_calculations,voucher_master_id,NULL,' . $id . ',calculation_type,' . $request->calculation_type,
            'calculation_type' => 'required',
        ],[
            'voucher_master_id.required' => 'The module is required.',
            'voucher_master_id.unique'   => 'The module has already been taken for the selected calculation type.',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            '_method'
        ]);

        $master = TaxCalculation::find($id);

        if (!$master) {
            return redirect()->route('tax-calculation.index')
                ->with('error','Tax Calculation not found!');
        }

        $master->update($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Tax Calculation updated successfully',
                'data'    => $master
            ]);
        }

        return redirect()->route('tax-calculation.index')
            ->with('success','Tax Calculation updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        TaxCalculation::find($request->id)->delete();

        $Redirect = 'tax-calculation';

        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data'    => [
                'redirect' => $Redirect,
            ]
        ]);
    }
    public function changeStatus(Request $request)
    {
       if ($request->ajax())
       {
           $data = array('status' => $request->status );
           $Update = TaxCalculation::where('id', '=', $request->id)->update($data);

           if($Update){
               return response()->json([
                   'success'=>true,
                   'message'=>['Tax Calculation status successfully change'],
                   'data'=>[
                       'redirect'=>'/buckets/',
                       'reload'=>true,
                   ]
               ]);
           }
           else{
               return response()->json([
                   'success'=>false,
                   'message'=>['Tax Status for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
               ]);
           }
       }
    }
}
