<?php

namespace App\Http\Controllers\VehicleDocumentTypes;

use Illuminate\Http\Request;
use App\Models\VehicleDocumentType;
use App\Http\Controllers\Controller;

class VehiclesDocumentTypesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
       $vehicle_document_types = VehicleDocumentType::select(
            'vehicle_document_types.id as vehicle_document_types_id',
            'vehicle_document_types.name as name',
            'vehicle_document_types.code as code',
            'vehicle_document_types.status as status'
        )->orderBy('vehicle_document_types.name', 'ASC');

        if ($request->ajax()) {
            $sort_by      = $request->get('sortby') ?? 10;
            $sort_type    = $request->get('sorttype');
            $search_query = $request->get('query');

            $vehicle_document_types = $vehicle_document_types->when(!empty($search_query), function ($query) use ($search_query) {
                return $query->where('vehicle_document_types.name', 'like', '%'.$search_query.'%');
            })->paginate($sort_by);

            return view('vehicle-document-types.table', compact('vehicle_document_types'));
        } else {
            $vehicle_document_types = $vehicle_document_types->paginate(10);

            return view('vehicle-document-types.index', compact('vehicle_document_types'));
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
       $vehicles_type = VehicleDocumentType::select(
            'vehicle_document_types.id as vehicle_document_types_id',
            'vehicle_document_types.name as name',
            'vehicle_document_types.code as code',
        )->get();

        return view('vehicle-document-types.create', compact('vehicles_type'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'name'   => 'required',
            'code'   => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->with('error', $validator->getMessageBag()->first())->withInput();
        }

        $vehicle_document_type = VehicleDocumentType::create([
            'name'   => $request->name,
            'code'   => $request->code,
        ]);

        return redirect()->route('vehicle-document-types.index')->with('success', 'Document Type was created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $vehicle_document_type = VehicleDocumentType::findOrFail($id);
        return view('vehicle-document-types.edit', compact('vehicle_document_type'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = \Validator::make($request->all(), [
            'name'   => 'required',
            'code'   => 'required',
        ]);

        if ($validator->fails()) {
            return redirect()->back()->with('error', $validator->getMessageBag()->first())->withInput();
        }

        $vehicle_document_type = VehicleDocumentType::findOrFail($id);
        $vehicle_document_type->update($request->all());

        return redirect()->route('vehicle-document-types.index')->with('success', 'Document Type was updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $vehicle_document_type = VehicleDocumentType::findOrFail($id);
        $vehicle_document_type->delete();

        return response()->json([
            'success' => true,
            'message' => 'Document Type Deleted successfully',
            'data' => [
                'redirect' => '', 
            ]
        ]);
    }

    public function changeStatus(Request $request)
    {
        if ($request->ajax()) {
            $data   = array('status' => $request->status );
            $update = VehicleDocumentType::where('id', '=', $request->id)->update($data);

            if($update){
                return response()->json([
                    'success'=>true,
                    'message'=>['Document Type status successfully change'],
                    'data'=>[
                       'redirect'=>'/users/',
                       'reload'=>true,
                    ]
                ]);
            } else {
                return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
                ]);
            }
        }
    }
}
