<?php

namespace App\Http\Controllers\VehicleDocumentValidity;

use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use App\Models\VehicleDocumentValidity;
use App\Models\vehicleDocumentType;
use App\Models\VehicleRegister;

class VehicleDocumentValidityController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request , $id)
    {

    $vehicle_register = VehicleRegister::select('vehicle_no' , 'id')
    ->where('id' , $id)
    ->first();

    $vehicleDocuments = vehicleDocumentType::select(
        'vehicle_document_types.name as document_type_name' ,
        'vehicle_document_types.id as id',
        'vehicle_document_validity.next_renewal_date as renewal_date',
        'vehicle_document_validity.last_renewal_date as last_renewal_date',
        'vehicle_document_validity.document_no as document_no',
        'vehicle_registers.id as vehicle_id',
        'vehicle_document_validity.is_received as is_received' , 
        'vehicle_document_validity.id as vehicle_document_validity_id' ,
        )
        ->leftJoin('vehicle_document_validity', 'vehicle_document_types.id', '=', 'vehicle_document_validity.document_id')
        ->leftJoin('vehicle_registers', 'vehicle_registers.id', '=', 'vehicle_document_validity.vehicle_id')
        ->orderBy('vehicle_document_types.name', 'ASC');

        if ($request->ajax()) {
            $sort_by      = $request->get('sortby') ?? 10;
            $sort_type    = $request->get('sorttype');
            $search_query = $request->get('query');

            $vehicleDocuments = $vehicleDocuments->when(!empty($search_query), function ($query) use ($search_query) {
                return $query->where('vehicle_document_types.name', 'like', '%'.$search_query.'%')
                ->orWhere('vehicle_document_validity.document_no', 'like', '%'.$search_query.'%');
            })->paginate($sort_by);

            return view('vehicle-document-validity.table', compact('vehicleDocuments' , 'vehicle_register'));
        } else {
            $vehicleDocuments = $vehicleDocuments->paginate(10);

            return view('vehicle-document-validity.index', compact('vehicleDocuments' ,'vehicle_register'));
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
   public function create()
{
    $vehicleDocuments = VehicleDocumentValidity::select()
    ->get();

    return view('vehicle-document-validity.create', compact('vehicleDocuments'));
}

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
   public function store(Request $request)
{
    $validator = \Validator::make($request->all(), [
        'document_no'       => 'required',
        'next_renewal_date' => 'nullable|date',
        'last_renewal_date' => 'nullable|date',
    ]);

    if ($validator->fails()) {
        return response()->json([
            'success' => false,
            'message' => $validator->errors()->first(),
            'data'    => ['redirect' => route('vehicle-document-validity.index')],
        ]);
    }

    $vehicleDocumentValidity = VehicleDocumentValidity::create([
        'document_no'       => $request->document_no,
        'next_renewal_date' => $request->next_renewal_date,
        'last_renewal_date' => $request->last_renewal_date,
    ]);

    return response()->json([
        'success' => true,
        'message' => 'Vehicle Document Validity created successfully',
        'data'    => ['redirect' => route('vehicle-document-validity.index')],
    ]);
}


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
public function edit($id)
{

    $vehicleDocumentType = VehicleDocumentType::leftJoin('vehicle_document_validity', 'vehicle_document_validity.document_id', '=', 'vehicle_document_types.id')
        ->select(
            'vehicle_document_types.name as document_type_name',
            'vehicle_document_types.id as id', 
            'vehicle_document_validity.id as vehicle_document_validity_id' ,
            'vehicle_document_validity.document_no as document_no',
            'vehicle_document_validity.next_renewal_date as next_renewal_date',
            'vehicle_document_validity.last_renewal_date as last_renewal_date'
        )
        ->where('vehicle_document_types.id', $id)
        ->first();

    return view('vehicle-document-validity.edit', compact('vehicleDocumentType'));
}




    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
public function update(Request $request, $id)
{


    $validator = \Validator::make($request->all(), [
        'document_no'       => 'required',
        'next_renewal_date' => 'required|date',
        'last_renewal_date' => 'required|date',
    ]);



    if ($validator->fails()) {

            return response()->json([
                'success'  => false,
                'message'  => $validator->getMessageBag()->first(),
                'data'     => [
                'redirect' => 'vehicle-document-validity.index'],
            ]);
        }

    $vehicleDocumentValidity = VehicleDocumentValidity::updateOrCreate([
            'document_id' => $id
        ],
        $request->all()
    );

    return response()->json([
        'success'  => true,
        'message'  => 'Vehicle Document Validity updated successfully',
        'data'     => [
        'redirect' => 'vehicle-document-validity.index', 
        ]
    ]);
}




    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
 public function destroy($id)
{
    $VehicleDocumentType = VehicleDocumentType::findOrFail($id);
    $VehicleDocumentType->delete();

    return response()->json([
        'success' => true,
        'message' => 'Vehicle Document Validity deleted successfully',
        'data'    => ['redirect' => route('vehicle-document-validity.index')],
    ]);
}



    public function changeStatus(Request $request)
    {
        if ($request->ajax()) {
            $data   = array('is_received' => $request->status );
            $update = VehicleDocumentValidity::where('id', '=', $request->id)->update($data);

            if($update){
                return response()->json([
                    'success'=>true,
                    'message'=>['Vehicle Document Validity status successfully change'],
                    'data'=>[
                       'redirect'=>'/users/',
                       'reload'=>true,
                    ]
                ]);
            } else {
                return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'vehicle-document-validity.index',
                   ]
                ]);
            }
        }
    }
}
