<?php

namespace App\Http\Controllers\VehicleTypes;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\VehicleRegister;
use App\Models\IpdAdmission;
use App\Models\Country;
use App\Models\AccountTitle;
use App\Models\SymptomClassification;
use App\Models\Symptom;
use App\Models\EnquirySource;
use App\Models\BodyVital;
use App\Models\vehicleTypeUpload;
use App\Models\IpdBodyVitalHistory;
use App\Models\IpdSymptomHistory;
use App\Models\IpdBedHistory;
use App\Models\BedGroup;
use App\Models\Bed;
use App\Models\VehicleType;
use App\Models\IpdConsultantHistory;
use App\Models\MaritalStatus;
use App\Models\BloodGroup;
use App\Models\AccountTransaction;
use App\Models\AcReceipt;
use App\Models\AcReceiptDetail;
use App\Models\VoucherType;
use App\Models\DischargeType;
use App\Models\AccountingGroup;
use App\Models\OpdBookings;
use App\Models\SaleInvoice;
use App\Models\SaleInvoiceDetail;
use App\Models\VoucherCollection;
use App\Models\VoucherCollectionDetail;
use App\Models\IpdDischarge;
use App\Models\IpdDischargeTypeSetting;
use App\Models\IpdDischargeDetail;
use App\Models\SaleInvoiceBatch;
use App\Models\DepartmentCLearanceSetting;
use App\Models\Sales\SaleReturns;
use Carbon\Carbon;
use Illuminate\Support\Facades\DB;
use App\Models\LabBillingReport;
use App\Models\Company;
use App\Models\ProductCategory;
use Illuminate\Support\Facades\Auth;
use App\Exports\IpdBillingStatementExport;
use App\Traits\TransactionSummeryTrait;
use Carbon\Exceptions\InvalidFormatException;
use Illuminate\Support\Facades\Validator;
use App\Models\Account;
use App\Models\AccountAddress;
use App\Models\AccountBank;
use App\Models\AccountLicense;
use App\Models\MasterType;
use App\Models\MasterCategory;
use App\Models\TaxRegisterCategory;
use App\Models\AccountPayment;
use App\Models\AccountAttachment;
use App\Models\AccountImage;
use App\Models\CompanyAddress;
use App\Models\AccountContact;
use App\Models\Gender;
use App\Models\User;
use App\Models\AccountRelativesDetail;
use App\Models\LicenseType;
use Spatie\Permission\Models\Role;
use Spatie\Permission\Models\Permission;
use App\Models\RelationType;
use App\Models\StudentHouse;
use Maatwebsite\Excel\Facades\Excel;
use App\Exports\AccountsExport;
use App\Models\AccountSettlementType;
use Illuminate\Validation\Rule;

class VehicleTypesController extends Controller
{
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        $vehicle_types = VehicleType::select(
            'vehicle_types.id as id',
            'vehicle_types.name as name',
            'vehicle_types.code as code',
            'vehicle_types.status as status'
        )->orderBy('vehicle_types.name', 'ASC');

        if ($request->ajax()) {
            $sort_by      = $request->get('sortby') ?? 10;
            $sort_type    = $request->get('sorttype');
            $search_query = $request->get('query');

            $vehicle_types = $vehicle_types->when(!empty($search_query), function ($query) use ($search_query) {
                return $query->where('vehicle_types.name', 'like', '%'.$search_query.'%');
            })->paginate($sort_by);

            return view('vehicle-types.table', compact('vehicle_types'));
        } else {
            $vehicle_types = $vehicle_types->paginate(10);

            return view('vehicle-types.index', compact('vehicle_types'));
        }
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function createVehicleType()
    {
        return view('accounts.create-vehicle-types');
    } 

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function storeVehicleType(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'name'   => 'required',
            'code'   => 'nullable',
        ]);

        if ($validator->fails()) {

            return response()->json([
                'success'  => false,
                'message'  => $validator->getMessageBag()->first(),
                'data'     => [
                'redirect' => 'vehicle-types.index'],
            ]);
        }

        $vehicle_type = VehicleType::create([
            'name'   => $request->name,
            'code'   => $request->code,
        ]);

        return response()->json([
            'success'  => true,
            'message'  => 'Vehicle Type Created successfully',
            'data'     => [
            'redirect' => 'vehicle-types.index', 
            ]
        ]);
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $vehicle_type = VehicleType::findOrFail($id);

        return view('accounts.edit-vehicle-types', compact('vehicle_type'));

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function updateVehicleType(Request $request, $id)
    {
        $validator = \Validator::make($request->all(), [
            'name'   => 'required',
            'code'   => 'nullable',
        ]);

        if ($validator->fails()) {
           return response()->json([
                'success'  => false,
                'message'  => $validator->getMessageBag()->first(),
                'data'     => [
                'redirect' => 'vehicle-types.index'],
            ]);
        }

        $vehicle_type = VehicleType::findOrFail($id);
        $vehicle_type->update($request->all());

        return response()->json([
            'success'  => true,
            'message'  => 'Vehicle Type updated successfully',
            'data'     => [
            'redirect' => 'vehicle-types.index', 
            ]
        ]);
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy($id)
    {
        $vehicle_type = VehicleType::findOrFail($id);
        $vehicle_type->delete();

        return response()->json([
            'success' => true,
            'message' => 'Vehicle Type Deleted successfully',
            'data' => [
                'redirect' => '', 
            ]
        ]);
    }


    public function changeStatus(Request $request)
    {
        if ($request->ajax()) {
            $data   = array('status' => $request->status );
            $update = VehicleType::where('id', '=', $request->id)->update($data);

            if($update){
                return response()->json([
                    'success'=>true,
                    'message'=>['Vehicle Type status successfully change'],
                    'data'=>[
                       'redirect'=>'/users/',
                       'reload'=>true,
                    ]
                ]);
            } else {
                return response()->json([
                   'success'=>false,
                   'message'=>['Error for change status'],
                   'data'=>[
                       'redirect'=>'',
                   ]
                ]);
            }
        }
    }

}
