<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Website\BrandsLogo;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class BrandsLogoController extends Controller
{
    public function index(Request $request)
    {
        $branch = BrandsLogo::select([
            'id',
            'name',
            'type',
            'image',
            'priority',
            'status'
        ]);

        $sort_by        = $request->get('sortby') ?? 10;
        $sort_type      = $request->get('sorttype');
        $query          = $request->get('query');
        if (!empty($query) && !empty($sort_by) && $query != " ") {

            $branch->where('title', 'like', '%' . $query . '%');
        }
        $branches = $branch->orderBy('id', 'desc')->paginate($sort_by);
        if ($request->ajax()) {
            return view('website-setting.brands-logo.table', compact('branches'));
        } else {
            return view('website-setting.brands-logo.index', compact('branches'));
        }
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        

        $priority    = BrandsLogo::max('priority');
        $priority    = $priority != '' ? $priority : 0;
        return view('website-setting.brands-logo.create', compact('priority'));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        if ($request->isMethod('post')) {
            // return $request;
            $validator =  Validator::make($request->all(), [
                'name'          => 'required',
                'type'          => 'required',
                'image'         => 'required'
            ]);
            if ($validator->fails()) {
                return response()->json(['success' => false, 'message' => $validator->errors()->all()]);
            } else {

                if ($request->hasFile('image')) {
                    $url        = \Str::slug($request->name);
                    $path       = "upload/brand-logo/" . $url . '/' . date('Y') . '/' . date('m');
                    $response = uploadImage($path, $request->image);

                    if ($response['status'] == true) {
                        $image = $response['file_name'];
                    } else {
                        return response()->json([
                            'success' => false,
                            'message' => $response['message'],
                            'data'    => []
                        ]);
                    }
                } else {
                    $image = '';
                }

                $Brand = BrandsLogo::create([
                    'name'                 => $request->name,
                    'type'                 => $request->type,
                    'details'              => $request->details,
                    'image'                => $image,
                    'priority'             => $request->priority,
                ]);
                //
                $Redirect = '/brands-logo/';
                return response()->json([
                    'success' => true,
                    'message' => ['Brand successfully created'],
                    'data' => $Brand
                ]);
            }
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, Request $request)
    {
        $brand = BrandsLogo::where(['id' => $id])->first();


        return view('website-setting.brands-logo.edit')->with([
            'brand' => $brand,
        ]);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, Request $request)
    {
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id, Request $request)
    {
        $validator =  Validator::make($request->all(), [
            'name'          => 'required',
            'type'          => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json(['success' => false, 'message' => $validator->errors()->all()]);
        } else {
            $brand = BrandsLogo::find($id);
            $url        = \Str::slug($request->name);
            if ($request->hasFile('image')) {
                $path       = "upload/brand-logo/" . $url . '/' . date('Y') . '/' . date('m');
                $response = uploadImage($path, $request->image);

                if ($response['status'] == true) {
                    $image = $response['file_name'];
                } else {
                    return response()->json([
                        'success' => false,
                        'message' => $response['message'],
                        'data'    => []
                    ]);
                }
            } else {
                $image = $brand->image;
            }

            $data = array(
                'name'                 => $request->name,
                    'type'                 => $request->type,
                    'details'              => $request->details,
                    'image'                => $image,
                    'priority'             => $request->priority,
            );
            $brand->update($data);
            $data = BrandsLogo::find($id);
            //
            $Redirect = '';
            return response()->json([
                'success' => true,
                'message' => ['Branch successfully Update'],
                'data' => $data
            ]);
        }
    }




    /**
     * change Blog status.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changestatus(Request $request)
    {
        if ($request->ajax()) {
            $data = array('status' => $request->status);
            $Update = BrandsLogo::where('id', '=', $request->id)->update($data);

            if ($Update) {
                return response()->json([
                    'success' => true,
                    'message' => ['Status successfully change'],
                    'data' => [
                        'redirect' => '/branches/',
                        'reload' => true,
                    ]
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => ['Error for change status'],
                    'data' => [
                        'redirect' => '',
                    ]
                ]);
            }
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $Delete = BrandsLogo::where(['id' => $request->id])->delete();
        $Redirect = '/brands-logo';
        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data' => [
                'redirect' => $Redirect,
            ]
        ]);
    }
}
