<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Website\ClientSay;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ClientSayController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:website-testimonials-list|website-testimonials-create|website-testimonials-edit|website-testimonials-delete', ['only' => ['index','store','list']]);
    }

    public function index(Request $request)
    {
        $ClientSays =ClientSay::select([
            'id',
            'name',
            'location',
            'profile',
            'status',
            'priority'
        ]);

            $sort_by        = $request->get('sortby') ?? 10;
            $sort_type      = $request->get('sorttype');
            $query          = $request->get('query');
            if(!empty($query) && !empty($sort_by) && $query!=" ")
            {

              $ClientSays->where('name', 'like', '%'.$query.'%');
            }
            $ClientSay =$ClientSays->orderBy('id','desc')->paginate($sort_by);
        if ($request->ajax()) {
          return view('website-setting.ClientSays.table', compact('ClientSay'));
        }
        else
        {
            return view('website-setting.ClientSays.index',compact('ClientSay'));
        }

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $priority    = ClientSay::max('priority');
        $priority    = $priority != '' ? $priority : 0;
        return view('website-setting.ClientSays.create',compact('priority'));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if($request->isMethod('post'))
        {
           // return $request;
            $validator =  Validator::make($request->all(),[
                'name'            => 'required',
                'description'      =>  'required'
            ]);
            if($validator->fails())
            {
                return response()->json(['success'=>false,'message'=>$validator->errors()->all()]);
            }
            else{

                if ($request->hasFile('profile')) {
                    $url        =\Str::slug($request->name);
                    $path       ="upload/ClientSays/".$url.'/'.date('Y').'/'.date('m');
                    $response = uploadImage($path,$request->profile);

                    if ($response['status'] == true)
                    {
                        $profile = $response['file_name'];
                    }
                    else
                    {
                        return response()->json([
                            'success' => false,
                            'message' => $response['message'],
                            'data'    => []
                        ]);
                    }
                }
                else
                {
                    $profile='';
                }

                $Category =ClientSay::create([
                    'name'        => $request->name,
                    'company_id'  => auth()->user()->company_id,
                    'description'  => $request->description,
                    'location'     => $request->location,
                    'profile'      => $profile,
                    'priority'     => $request->priority,
                    'video_url'    => $request->video_url,
                ]);
                //
                $Redirect = '/testimonials/';
                return response()->json([
                    'success'=>true,
                    'message'=>['Client Say successfully created'],
                    'data'=>$Category,
                ]);
            }
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id,Request $request)
    {
        $ClientSay =ClientSay::where(['id'=>$id])->first();
        //
        return view('website-setting.ClientSays.edit')->with(['ClientSay'=>$ClientSay]);
    }


     /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id,Request $request)
    {

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id,Request $request)
    {
        $validator =  Validator::make($request->all(),[
            'name'            => 'required',
            // 'description'      =>  'required'
        ]);
        if($validator->fails())
        {
            return response()->json(['success'=>false,'message'=>$validator->errors()->all()]);
        }
        else{
            $SocialClientSay=ClientSay::find($id);
            $url        =\Str::slug($request->name);
            if ($request->hasFile('profile')) {
                $path       ="upload/ClientSays/".$url.'/'.date('Y').'/'.date('m');
                $response = uploadImage($path,$request->profile);

                if ($response['status'] == true)
                {
                    $profile = $response['file_name'];
                }
                else
                {
                    return response()->json([
                        'success' => false,
                        'message' => $response['message'],
                        'data'    => []
                    ]);
                }
            }
            else
            {
                $profile=$SocialClientSay->profile;
            }

            $data = array(
                    'name'        => $request->name,
                    'company_id'  => auth()->user()->company_id,
                    'description'  => $request->description,
                    'location'     => $request->location,
                    'profile'      => $profile,
                    'priority'     => $request->priority,
                    'video_url'    => $request->video_url,
                    );
            $SocialClientSay->update($data);
            //
            $Redirect = '';
            $data=ClientSay::find($id);
            return response()->json([
                'success'=>true,
                'message'=>['Client Say successfully Update'],
                'data'=>$data,
            ]);
        }
    }




    /**
     * change ClientSay status.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changestatus(Request $request)
    {
        if ($request->ajax())
        {
            $data = array('status' => $request->status );
            $Update =ClientSay::where('id', '=', $request->id)->update($data);

            if($Update){
                return response()->json([
                    'success'=>true,
                    'message'=>['Status successfully change'],
                    'data'=>[
                        'redirect'=>'/testimonials/',
                        'reload'=>true,
                    ]
                ]);
            }
            else{
                return response()->json([
                    'success'=>false,
                    'message'=>['Error for change status'],
                    'data'=>[
                        'redirect'=>'',
                    ]
                ]);
            }
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $Delete =ClientSay::where(['id'=>$request->id])->delete();
        $Redirect = '/client-say';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);
    }
}
