<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Website\ContactEnquery;
use Illuminate\Http\Request;

class ContactEnquiryController extends Controller
{
    public function index(Request $request)
    {
      $ContactEnquery = ContactEnquery::select(['id','name','email','phone','subject','msg'])->orderBy('id','desc')->paginate(10);
        if ($request->ajax()) {
            $sort_by = $request->get('sortby');
            $sort_type = $request->get('sorttype');
            $query = $request->get('query');
            if(!empty($query) && !empty($sort_by) && $query!=" ")
            {
              $ContactEnquery = ContactEnquery::query()->select(['id','name','email','phone','subject','msg'])
              ->where('name', 'like', '%'.$query.'%')
              ->orWhere('email', 'like', '%'.$query.'%')
              ->orderBy('id','desc')
              ->paginate($sort_by);
            }
            elseif($sort_by)
            {
              $ContactEnquery = ContactEnquery::select(['id','name','email','phone','subject','msg'])->orderBy('id','desc')->paginate($sort_by);
            }
            else
            {
              $ContactEnquery = ContactEnquery::select(['id','name','email','phone','subject','msg'])->orderBy('id','desc')->paginate(10);
            }   
          return view('website-setting.contact-enquiry.table', compact('ContactEnquery'));
        }
        else
        {
            return view('website-setting.contact-enquiry.index',compact('ContactEnquery'));
        }
        
    }

     /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request)
    {
        $Delete = ContactEnquery::where(['id'=>$request->id])->delete();
        $Redirect = '/contact-enquiry';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);
    }
}
