<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Website\ContentSubCategory;
use App\Models\Website\PublicContent;
use App\Models\Website\PublicContentCategory;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ContentSubCategoryController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:website-content-sub-category-list|website-content-sub-category-create|website-content-sub-category-edit|website-content-sub-category-delete', ['only' => ['index', 'store', 'list']]);
    }

    public function index(Request $request)
    {
        $Subcategorys = ContentSubCategory::with('getCategory')
                        ->select(['id', 'priority_status', 'sub_category_name', 'category_id', 'status']);
        if($request->id){
            $Subcategorys = $Subcategorys->where('category_id',$request->id);
        }
        $sort_by    = $request->get('sortby') ?? 10;
        $sort_type  = $request->get('sorttype');
        $query      = $request->get('query');
        if (!empty($query) && !empty($sort_by) && $query != " ") {
            $Subcategorys->where('sub_category_name', 'like', '%' . $query . '%')
                ->orWhere('priority_status', 'like', '%' . $query . '%');
        }
        $Subcategory = $Subcategorys->orderBy('id', 'desc')->paginate($sort_by);
        if ($request->ajax()) {
            return view('website-setting.Subcategory.table', compact('Subcategory'));
        } else {
            return view('website-setting.Subcategory.index', compact('Subcategory'));
        }
    }


    public function indexNew(Request $request)
    {
        $Subcategorys = ContentSubCategory::with('getCategory')
                        ->select(['id', 'priority_status', 'sub_category_name', 'category_id', 'status']);
        $id =  $request->id ?? 0;
        
        $Subcategorys = $Subcategorys->where('category_id',$id);
        
        $sort_by    = $request->get('sortby') ?? 10;
        $sort_type  = $request->get('sorttype');
        $query      = $request->get('query');
        if (!empty($query) && !empty($sort_by) && $query != " ") {
            $Subcategorys->where('sub_category_name', 'like', '%' . $query . '%')
                ->orWhere('priority_status', 'like', '%' . $query . '%');
        }
        $Subcategory = $Subcategorys->orderBy('id', 'desc')->paginate($sort_by);
        if ($request->ajax()) {
            return view('website-setting.Subcategory.all-table', compact('Subcategory','id'));
        } 
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $Category = PublicContentCategory::select(['id', 'name'])->where('status',1)->get();

        return view('website-setting.Subcategory.create', compact('Category'));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        if ($request->isMethod('post')) {
            $validator =  Validator::make($request->all(), [
                'sub_category_name' => 'required|unique:content_sub_category',
                'category_name' => 'required',
            ]);
            if ($validator->fails()) {
                return response()->json(['success' => false, 'message' => $validator->errors()->all()]);
            } else {
                $Category = ContentSubCategory::create([
                    'sub_category_name' => $request->sub_category_name,
                    'priority_status' => $request->priority_status,
                    'category_id' => $request->category_name,
                ]);
                //
                $Redirect = '/content-sub-category';
                return response()->json([
                    'success' => true,
                    'message' => ['Sub Category successfully created'],
                    'data' => [
                        'redirect' => $Redirect,
                        'reload' => true,
                    ]
                ]);
            }
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, Request $request)
    {
        $Category = PublicContentCategory::select(['id', 'name'])->where('status',1)->get();
        $Subcategory = ContentSubCategory::find($id);
        return view('website-setting.Subcategory.edit')->with(['Category' => $Category, 'SubCategory' => $Subcategory]);
    }

    public function show($id, Request $request)
    {
        $sort_by = $request->get('sortby') ?? 10;
        $sort_type  = $request->get('sorttype');
        $query      = $request->get('query');
        $category_id = $request->category_id;
        $content   = PublicContent::with(['getsubCategory','getCategory'])
                                    ->select(['id','title','description','link','prority_status','new_tag',
                                    'status','public_content_category_id','sub_category_id'])
                                    ->where(['sub_category_id'=>$id,'public_content_category_id'=>$category_id]);
     
        if(!empty($query) && !empty($sort_by) && $query!=" ")
        {
            $content->where('title', 'like', '%'.$query.'%')
                    ->orWhere('description', 'like', '%'.$query.'%');
        }
        $content =$content->orderBy('id','desc')->paginate($sort_by);
        if ($request->ajax()) 
        {
          return view('website-setting.contents.table1', compact('content','id','category_id'));
        }
        else
        {
            return view('website-setting.Subcategory.show',compact('id','category_id','content'));
        }
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id, Request $request)
    {
        $validator = \Validator::make($request->all(), ['sub_category_name' => 'required']);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except(['_token', '_method']);
        $data = ContentSubCategory::whereId($id)->update($data);
        $data = ContentSubCategory::find($id);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Sub Category updated successfully',
                'data' => $data
            ]);
        }
        return redirect()->route('content-sub-category.index')
            ->with('success', 'Sub Category updated successfully');
    }

    /**
     * change service status.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changestatus(Request $request)
    {
        if ($request->ajax()) {
            $data = array('status' => $request->status);
            $Update = ContentSubCategory::where('id', '=', $request->id)->update($data);

            if ($Update) {
                return response()->json([
                    'success' => true,
                    'message' => ['Sub Category successfully change'],
                    'data' => [
                        'redirect' => '',
                        'reload' => true,
                    ]
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => ['Error for change status'],
                    'data' => [
                        'redirect' => '',
                    ]
                ]);
            }
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $Delete = ContentSubCategory::where(['id' => $request->id])->delete();
        $Redirect = '/content-sub-category';
        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data' => [
                'redirect' => $Redirect,
            ]
        ]);
    }
}
