<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Website\Faq;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class FaqController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:website-faq-list|website-faq-create|website-faq-edit|website-faq-delete', ['only' => ['index','store','list']]);
    }

    public function index(Request $request)
    {
        $Faqs = Faq::select([
            'id',
            'question',
            'status'
        ]);

        $sort_by        = $request->get('sortby') ?? 10;
        $sort_type      = $request->get('sorttype');
        $query          = $request->get('query');
        if (!empty($query) && !empty($sort_by) && $query != " ") {

            $Faqs->where('question', 'like', '%' . $query . '%');
        }
        $Faq = $Faqs->orderBy('id', 'desc')->paginate($sort_by);
        if ($request->ajax()) {
            return view('website-setting.faqs.table', compact('Faq'));
        } else {
            return view('website-setting.faqs.index', compact('Faq'));
        }
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('website-setting.faqs.create');
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        $validator = \Validator::make($request->all(), [ 'question' => 'required',
                                                        'ans'      =>  'required']);
        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except(['_token']);
        $data['company_id'] = auth()->user()->company_id;

        $data = Faq::create($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Faqs Media created successfully',
                'data' => $data
            ]);
        }

        return redirect()->route('faqs.index')
            ->with('success', 'Faqs Media created successfully');

    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, Request $request)
    {
        $FAQ = Faq::where(['id' => $id])->first();
        //
        return view('website-setting.faqs.edit')->with(['FAQ' => $FAQ]);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, Request $request)
    {
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id, Request $request)
    {

        $validator = \Validator::make($request->all(), ['question' => 'required',
                                                        'ans'      =>  'required']);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except(['_token', '_method']);
        $data = Faq::whereId($id)->update($data);
        $data = Faq::find($id);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'faqs updated successfully',
                'data' => $data
            ]);
        }
        return redirect()->route('faqs.index')
            ->with('success', 'faqs updated successfully');
    }




    /**
     * change service status.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changestatus(Request $request)
    {
        if ($request->ajax()) {
            $data = array('status' => $request->status);
            $Update = Faq::where('id', '=', $request->id)->update($data);

            if ($Update) {
                return response()->json([
                    'success' => true,
                    'message' => ['Status successfully change'],
                    'data' => [
                        'redirect' => '/faqs/',
                        'reload' => true,
                    ]
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => ['Error for change status'],
                    'data' => [
                        'redirect' => '',
                    ]
                ]);
            }
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $Delete = Faq::where(['id' => $request->id])->delete();
        $Redirect = '/faqs';
        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data' => [
                'redirect' => $Redirect,
            ]
        ]);
    }
}
