<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\City;
use App\Models\InvoiceSerialSetting;
use App\Models\Website\Blog;
use App\Models\Website\ClientSay;
use App\Models\Website\ContactEnquery;
use App\Models\Website\ContentSubCategory;
use App\Models\Website\Faq;
use App\Models\Website\HomeCollection;
use App\Models\Website\Plan;
use App\Models\Website\Post;
use App\Models\Website\Project;
use App\Models\Website\Project_Developer;
use App\Models\Website\Project_Location;
use App\Models\Website\Project_Video;
use App\Models\Website\ProjectAmenities;
use App\Models\Website\ProjectConnectivity;
use App\Models\Website\ProjectImage;
use App\Models\Website\ProjectOverview;
use App\Models\Website\ProjectWhyus;
use App\Models\Website\PublicContent;
use App\Models\Website\PublicContentCategory;
use App\Models\Website\Service;
use App\Models\Website\Slider;
use App\Models\Website\TblPhotoGallery;
use App\Models\Website\TblPhotoGalleryImage;
use App\Models\Website\TblVideoGallery;
use App\Models\Website\Team;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;
use Validator;
use Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Mail;

class FrontController extends Controller
{
    public function index()
    {
        $data['sliders']=Slider::select('image')->where('status','1')->orderBy('priority_status','desc')->get();
        $data['services']=Service::select(['title','description','icon'])->where('status','1')->latest('id')->get();
        $data['clientsays']=ClientSay::select(['name','location','description','profile'])->where('status','1')->latest('id')->get();
        $data['FAQS']=Faq::select(['question','ans'])->where('status','1')->latest('id')->get();
        $data['plans']=Plan::select(['title','price','test','description'])->where('status','1')->latest('id')->get();

        $data['videoGallery']=TblVideoGallery::where('status','1')->orderBy('priority','asc')->limit(3)->get(['cover_pic','title','video_url']);
        $data['Blogs']=Blog::where('status','1')->latest('id')->limit(3)->get(['title','slug','image','description']);

        $data['Post']=Post::where('title','Home')->get()->first();
        $data['abouts']=Post::where('title','About Us')->get()->first();
        $data['projects']=Project::where('status','1')
        ->limit(5)->get(['project_name','amount','bhk','bath','beds','kitchan','cover_pic','slug']);
        return view('website.index',$data);
    }
    /***************************User Login ***********************/
    

    
    public function about()
    {
        $Post=Post::where('title','About Us')->get()->first();
        return view('website.about-us',compact('Post'));
    }
    public function blogs(Request $request)
    {
        $Blogs=Blog::select(['id','title','description','slug','image','created_at'])->where(['status'=>'1'])->paginate(12);
        if ($request->ajax()) 
        {
            return view('website.blogajax',compact('Blogs'));
        }
        $Post=Post::where('title','Blog')->get()->first();
        return view('website.blog',compact('Blogs','Post'));
    }
    public function homeCollection()
    {
        
        $Post=Post::where('title','Home Collection')->get()->first();
        return view('website.home-collection',compact('Post'));
    }
    
    public function searchCity(Request $request)
    {
        $query = $request->get('q');
              $filterResult=[];
              if($query){
                  //DB::enableQueryLog();
              $filterResult=City::select(['id','name'])
                        ->where('name', 'LIKE', '%'. $query. '%')
                        ->get();
                       // dd(DB::getQueryLog());
                  }
                  return response()->json($filterResult);
    }

    public function searchslot(Request $request)
    {
        $query = $request->get('q');
              $filterResult=[];
              if($query){
                  //DB::enableQueryLog();
              $filterResult=Service::select(['id','title'])
                        ->where('title', 'LIKE', '%'. $query. '%')
                        ->get();
                       // dd(DB::getQueryLog());
                  }
                  return response()->json($filterResult);
    }
    public function blogDetails($slug,Request $request)
    {
        $Blogs=Blog::select(['id','title','description','slug','image','created_at'])->where(['slug'=>$slug])->first();
        $Post=Post::where('title','Blog')->get()->first();
        return view('website.blog-detail',compact('Blogs','Post'));
    }
    
    public function photogallery(Request $request)
    {
        $PhotoData=TblPhotoGallery::select(['id','title','cover_pic'])->where('status','1')->orderBy('priority','asc')->paginate(20);
        $Post=Post::where('title','Photo Gallery')->get()->first();
        if ($request->ajax()) 
        {
            return view('website.gallery-image-ajax',compact('PhotoData','Post'));
        }
        return view('website.gallery-image',compact('PhotoData','Post'));
    }
    public function photogallerydetails($id)
    {
        $PhotoDatas=TblPhotoGallery::select(['id','title','cover_pic'])->find($id)->first();
        $Post=Post::where('title','Photo Gallery')->get()->first();
        $PhotoData=TblPhotoGalleryImage::where('photo_gallery_id',$id)->where('status','1')->orderBy('priority','asc')->get(['image_name','image']);
        return view('website.gallery-image-details',compact('PhotoData','Post','PhotoDatas'));
    }
    public function videogallery(Request $request)
    {
        $VideoData=TblVideoGallery::select(['id','title','cover_pic','video_url'])->where('status','1')->paginate(20);
        $Post=Post::where('title','Video Gallery')->get()->first();
        if ($request->ajax()) 
        {
            return view('website.video-gallery-ajax',compact('VideoData','Post'));
        }
        return view('website.gallery-video',compact('VideoData','Post'));
    }
    public function contactus()
    {
        $Post=Post::where('title','Contact Us')->get()->first();
        return view('website.contact-us',compact('Post'));
    }
    public function services()
    {
        $services=Service::select(['title','description','icon'])->where(['status'=>'1'])->get();
        $Post=Post::where('title','Services')->get()->first();
        return view('website.service',compact('services','Post'));
    }


    public function allPublicContent(Request $request)
    {
        
        if ($request->ajax()) 
        {
            if($request->sorttype=='Category')
            {
                $id= (int)$request->get('query');
                $data['content']=PublicContent::select(['id','public_content_category_id','sub_category_id','title','description','link','files'])
                ->where(['status'=>'1'])
                ->where('public_content_category_id',$id)
                ->latest('id')->paginate(10);
            }
            elseif($request->sorttype=='SubCategory')
            {
                $id= (int)$request->get('query');
                $data['content']=PublicContent::select(['id','public_content_category_id','sub_category_id','title','description','link','files'])
                ->where(['status'=>'1'])
                ->where('sub_category_id',$id)
                ->latest('id')->paginate(10);
            }
            return view('website.public-content-list',$data);
        }
        else
        {
            if(isset($request->category) && $request->category!='')
            {
                $data['category']=ContentSubCategory::where(['category_id'=>$request->category])->get();
                $data['catename']=PublicContentCategory::where('id',$request->category)->select('name')->first();
                $data['content']=PublicContent::select(['id','public_content_category_id','sub_category_id','title','description','link','files'])
                ->where(['status'=>'1'])
                ->where('public_content_category_id',$request->category)
                ->latest('id')->paginate(10);
            }
            elseif(isset($request->subcategory) && $request->subcategory!='')
            {
                $data['category']=ContentSubCategory::get();
                $data['catename']=ContentSubCategory::where('id',$request->subcategory)->select('sub_category_name as name')->first();
                $data['content']=PublicContent::select(['id','public_content_category_id','sub_category_id','title','description','link','files'])
                ->where(['status'=>'1'])
                ->where('sub_category_id',$request->subcategory)
                ->latest('id')->paginate(10);
            }
            else
            {
                $data['content']=PublicContent::select(['id','public_content_category_id','sub_category_id','title','description','link','files'])
                ->where(['status'=>'1'])
                ->latest('id')->paginate(10);
            }
            //dd($data['catename']->name);
            return view('website.all-public-content',$data);
        }
         
    }


  

   

    /********************contact Equery Submit********************/
    
    public function submitEnquery(Request $request)
    {
        if($request->isMethod('post'))
        {
           // return $request;
            $validator =  Validator::make($request->all(),[
                'name' => 'required',
                'email' => 'required',
                'phone' => 'required',
                'subject' => 'required',
            ]);
            if($validator->fails())
            {
                return response()->json(['success'=>false,'message'=>$validator->errors()->all()]);
            }
            else{
                
                $data=ContactEnquery::create($request->all());
                        if($data)
                        {
                            $Redirect = '/contact-us';
                            return response()->json([
                                'success'=>true,
                                'message'=>['Thank Your For Submit Enquery'],
                                'data'=>[
                                'redirect'=>$Redirect,
                                'reload'=>true,
                                ]
                            ]);
                        }
                    }
        }
                
    }

    public function homestore(Request $request)
    {
        if($request->isMethod('post'))
        {
           // return $request;
            $validator =  Validator::make($request->all(),[
                'name' => 'required',
                'phone' => 'required|max:10|min:10',
            ]);
            if($validator->fails())
            {
                return response()->json(['success'=>false,'message'=>$validator->errors()->all()]);
            }
            else{
                $CompanyDetails=getComapnyName();
                $input=$request->all();
                $input['vdate']=date('Y-m-d');
                $data=HomeCollection::create($input);
                $datas=['name'          => $request->name,
                        'phone'         => $request->phone,
                        'booking_id'    => $data->id,
                        'address'       =>mb_substr($request->city,0,20),
                        'time'          =>'Not Avaible',
                        'company_name'  =>$CompanyDetails->name,
                        'company_no'    =>$CompanyDetails->mobile_number,
                        ];
                 $Response = SendCollectionEnquiryMessage($datas);
                        if($data)
                        {
                            $Redirect = '/';
                            return response()->json([
                                'success'=>true,
                                'message'=>['Thank Your For Submit Enquery'],
                                'data'=>[
                                'redirect'=>$Redirect,
                                'reload'=>true,
                                ]
                            ]);
                        }
                    }
        }
                
    }



    public function management(Request $request)
    {
        $TeamData=Team::select(['id','name','designation','profile'])->where('status','1')->paginate(8);
        $Post=Post::where('title','Management')->get()->first();
        if ($request->ajax()) 
        {
            return view('website.gallery-image-ajax',compact('TeamData','Post'));
        }
        return view('website.management',compact('TeamData','Post'));
    }

    public function project(Request $request)
    {
        $ProjectData=Project::where('status','1')->get(['project_name','amount','bhk','bath','beds','kitchan','cover_pic','slug']);
        $Post=Post::where('title','Our Project')->get()->first();
        return view('website.projects',compact('ProjectData','Post'));
    }
    public function projectDetails($slug)
    {
        $ProjectData=Project::where('slug',$slug)->get(['id','project_name','amount','bhk','bath','beds','kitchan','cover_pic','slug'])->first();
        $Post=Post::where('title','Photo Gallery')->get()->first();
        $galleryImage=ProjectImage::where('project_id',$ProjectData->id)->where('status','1')->get(['image']);
        $projectwhy=ProjectWhyus::where('project_id',$ProjectData->id)->where('status','1')->get(['description','list_of_point']);
        $projectoverviews=ProjectOverview::where('project_id',$ProjectData->id)->where('status','1')->get(['description','list_of_point','boucher']);
        $videos=Project_Video::where('project_id',$ProjectData->id)->where('status','1')->get(['cover_image','url']);
        $locations=Project_Location::where('project_id',$ProjectData->id)->where('status','1')->get(['location','email','mobile','google_map']);
        $amenities=ProjectAmenities::where('project_id',$ProjectData->id)->where('status','1')->get(['name','image']);
        $nearby=ProjectConnectivity::where('project_id',$ProjectData->id)->where('status','1')->get(['name','image']);
        $developers=Project_Developer::where('project_id',$ProjectData->id)->where('status','1')->get(['name','image','description']);
        $reletedProjects=Project::where('status','1')->where('id','!=',$ProjectData->id)->limit(3)->get(['project_name','amount','bhk','bath','beds','kitchan','cover_pic','slug']);
        return view('website.project-detail',compact('ProjectData','Post','galleryImage','projectwhy','projectoverviews','videos','locations','amenities','nearby','developers','reletedProjects'));
    }
    public function privacyPolicy(Request $request)
    {
        $Post=Post::where('title','Privacy Policy')->get()->first();
        return view('website.dynamic-page',compact('Post'));
    }
    public function termConditions(Request $request)
    {
        $Post=Post::where('title','Terms & Conditions')->get()->first();
        return view('website.dynamic-page',compact('Post'));
    }

    

}
