<?php

namespace App\Http\Controllers\Website;

use App\Exports\ExportVisitRequest;
use App\Http\Controllers\Controller;
use App\Models\Website\HomeCollection;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Maatwebsite\Excel\Facades\Excel;

class HomeCollectionController extends Controller
{
    public function index(Request $request)
    {
      $HomeCollections =HomeCollection::leftJoin('cities','cities.id','=','home_collections.city')->
                                        leftJoin('services','services.id','=','home_collections.slot')->
                                        select([
                                            'home_collections.id',
                                            'home_collections.name',
                                            'home_collections.phone',
                                            'home_collections.city',
                                            'home_collections.vdate',
                                            'home_collections.address',
                                            'home_collections.pincode',
                                            'home_collections.slot',
                                            'home_collections.message',
                                            'cities.name as city_name',
                                            'services.title as slot_name',
                                            'home_collections.collection_status',
                                            'home_collections.status',
                                            'home_collections.email'
                                            ]);
        
            $sort_by        = $request->get('sortby') ?? 10;
            $sort_type      = $request->get('sorttype');
            $query          = $request->get('query');
            $todate         = $request->get('todate');
            
            if($sort_type=='datefilter')
            {
                $HomeCollections->where('home_collections.vdate','>=', $query)
                ->where('home_collections.vdate','<=',$todate);
            }
            elseif(!empty($query) && !empty($sort_by) && $query!=" ")
            {
             
              $HomeCollections->where('name', 'like', '%'.$query.'%');
            }
            $HomeCollection =$HomeCollections->orderBy('id','desc')->paginate($sort_by);
        if ($request->ajax()) {  
          return view('website-setting.HomeCollections.table', compact('HomeCollection'));
        }
        else
        {
            return view('website-setting.HomeCollections.index',compact('HomeCollection'));
        }
        
    }



    public function changestatus(Request $request)
    {
        if ($request->ajax())
        {
            $data = array('status' => $request->status );
            $Update =HomeCollection::where('id', '=', $request->id)->update($data);

            if($Update){
                return response()->json([
                    'success'=>true,
                    'message'=>['Status successfully change'],
                    'data'=>[
                        'redirect'=>'/visit-request/home-collections',
                        'reload'=>true,
                    ]
                ]);
            }
            else{
                return response()->json([
                    'success'=>false,
                    'message'=>['Error for change status'],
                    'data'=>[
                        'redirect'=>'',
                    ]
                ]);
            }
        }
    }



     /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request)
    {
        $Delete =HomeCollection::where(['id'=>$request->id])->delete();
        $Redirect = '/visit-request/home-collections';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);
    }


    public function edit($id,Request $request)
    {
        $homeCollection = HomeCollection::where(['id'=>$id])->first();
        return view('website-setting.HomeCollections.edit')->with(['homeCollection'=>$homeCollection]);
    }


     /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id,Request $request)
    {
        $validator =  Validator::make($request->all(),[
            'name'       => 'required',
            'phone'      => 'required'
        ]);
        if($validator->fails())
        {
            return response()->json(['success'=>false,'message'=>$validator->errors()->all()]);
        }
        else{
            $Collection=HomeCollection::find($id);
            $Collection->update($request->all());
            //
            $Redirect = '';
            return response()->json([
                'success'=>true,
                'message'=>['Home Collection successfully Update'],
                'data'=>[
                'redirect'=>'/visit-request/home-collections',
                'reload'=>false,
                ]
            ]);
        }
    }

    public function updateCollectionStatus($id,Request $request)
    {


            $Collection=HomeCollection::find($id);
            $Collection->update($request->all());
            //
            $Redirect = '';
            return response()->json([
                'success'=>true,
                'message'=>['Home Collection successfully Update'],
                'data'=>[
                'redirect'=>'/visit-request/home-collections',
                'reload'=>false,
                ]
            ]);
    }

    public function exportRequest(Request $request){
        $dataFilter= HomeCollection::where('home_collections.vdate','>=', $request->from_date)
        ->where('home_collections.vdate','<=',$request->to_date)->get();
          
        return Excel::download(new ExportVisitRequest($dataFilter->toArray()), 'Visit-Request-Report.xlsx');
    }

    
}
