<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Website\Plan;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;



class PlanController extends Controller
{
    public function index(Request $request)
    {
        $Plans =Plan::select([
                        'id',
                        'title',
                        'price',
                        'test',
                        'status'
                        ]);
        
            $sort_by        = $request->get('sortby') ?? 10;
            $sort_type      = $request->get('sorttype');
            $query          = $request->get('query');
        if(!empty($query) && !empty($sort_by) && $query!=" ")
        {
            
            $Plans->where('title', 'like', '%'.$query.'%');
        }
            $Plan =$Plans->orderBy('id','desc')->paginate($sort_by);
        if ($request->ajax()) {  
          return view('website-setting.Plans.table', compact('Plan'));
        }
        else
        {
            return view('website-setting.Plans.index',compact('Plan'));
        }
        
    }

    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('website-setting.Plans.create');
    }

    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if($request->isMethod('post'))
        {
           
            $validator =  Validator::make($request->all(),[
                'title'      => 'required',
                'price'      =>  'required'
            ]);
            if($validator->fails())
            {
                return response()->json(['success'=>false,'message'=>$validator->errors()->all()]);
            }
            else{

                $Category =Plan::create([
                                'title'        => $request->title,
                                'price'        => $request->price,
                                'test'         => $request->test,
                                'description'  => $request->description,
                            ]);
                //
                $Redirect = '/package-plans/';
                return response()->json([
                    'success'=>true,
                    'message'=>['Package & Plan successfully created'],
                    'data'=>[
                    'redirect'=>$Redirect,
                    'reload'=>true,
                    ]
                ]);
            }
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id,Request $request)
    {
        $Plan =Plan::where(['id'=>$id])->first();
        //
        return view('website-setting.Plans.edit')->with(['Plan'=>$Plan]);
    }


     /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id,Request $request)
    {
        
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id,Request $request)
    {
        $validator =  Validator::make($request->all(),[
            'title'      => 'required',
            'price'      =>  'required'
        ]);
        if($validator->fails())
        {
            return response()->json(['success'=>false,'message'=>$validator->errors()->all()]);
        }
        else{
            $SocialPlan=Plan::find($id);
            $data = array(
                'title'        => $request->title,
                'price'        => $request->price,
                'test'         => $request->test,
                'description'  => $request->description,
                    );
            $SocialPlan->update($data);
            //
            $Redirect = '';
            return response()->json([
                'success'=>true,
                'message'=>['Package & Plan successfully Update'],
                'data'=>[
                'redirect'=>'/package-plans/',
                'reload'=>false,
                ]
            ]);
        }
    }



    
    /**
     * change Plan status.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changestatus(Request $request)
    {
        if ($request->ajax())
        {
            $data = array('status' => $request->status );
            $Update =Plan::where('id', '=', $request->id)->update($data);

            if($Update){
                return response()->json([
                    'success'=>true,
                    'message'=>['Status successfully change'],
                    'data'=>[
                        'redirect'=>'/package-plans/',
                        'reload'=>true,
                    ]
                ]);
            }
            else{
                return response()->json([
                    'success'=>false,
                    'message'=>['Error for change status'],
                    'data'=>[
                        'redirect'=>'',
                    ]
                ]);
            }
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request)
    {
        $Delete =Plan::where(['id'=>$request->id])->delete();
        $Redirect = '/client-say';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);
    }
}
