<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Website\Service;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ServicesController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:website-services-list|website-services-create|website-services-edit|website-services-delete', ['only' => ['index','store','list']]);
    }

    public function index(Request $request)
    {
        $Services =Service::select([
            'id',
            'title',
            'status',
            'icon'
        ]);

            $sort_by        = $request->get('sortby') ?? 10;
            $sort_type      = $request->get('sorttype');
            $query          = $request->get('query');
            if(!empty($query) && !empty($sort_by) && $query!=" ")
            {

              $Services->where('title', 'like', '%'.$query.'%');
            }
            $Service =$Services->orderBy('id','desc')->paginate($sort_by);
        if ($request->ajax()) {
          return view('website-setting.Services.table', compact('Service'));
        }
        else
        {
            return view('website-setting.Services.index',compact('Service'));
        }

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('website-setting.Services.create');
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        if($request->isMethod('post'))
        {
           // return $request;
            $validator =  Validator::make($request->all(),[
                'title'            => 'required',
            ]);
            if($validator->fails())
            {
                return response()->json(['success'=>false,'message'=>$validator->errors()->all()]);
            }
            else{

                if ($request->hasFile('icon')) {
                    $url        =\Str::slug($request->title);
                    $path       ="upload/Services/".$url.'/'.date('Y').'/'.date('m');
                    $response = uploadImage($path,$request->icon);

                    if ($response['status'] == true)
                    {
                        $icon = $response['file_name'];
                    }
                    else
                    {
                        return response()->json([
                            'success' => false,
                            'message' => $response['message'],
                            'data'    => []
                        ]);
                    }
                }
                else
                {
                    $icon='';
                }

                $Category =Service::create([
                                'title'        => $request->title,
                                'description'  => $request->description,
                                'icon'         =>$icon,
                            ]);
                //
                $Redirect = '/services/';
                return response()->json([
                    'success'=>true,
                    'message'=>['Service successfully created'],
                    'data' => $Category,
                ]);
            }
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id,Request $request)
    {
        $Service =Service::where(['id'=>$id])->first();
        //
        return view('website-setting.Services.edit')->with(['Service'=>$Service]);
    }


     /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id,Request $request)
    {

    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id,Request $request)
    {
        $validator =  Validator::make($request->all(),[
            'title'            => 'required',
        ]);
        if($validator->fails())
        {
            return response()->json(['success'=>false,'message'=>$validator->errors()->all()]);
        }
        else{
            $SocialService=Service::find($id);

            if ($request->hasFile('icon')) {
                $url        =\Str::slug($request->title);
                $path       ="upload/Services/".$url.'/'.date('Y').'/'.date('m');
                $response = uploadImage($path,$request->icon);

                if ($response['status'] == true)
                {
                    $icon = $response['file_name'];
                }
                else
                {
                    return response()->json([
                        'success' => false,
                        'message' => $response['message'],
                        'data'    => []
                    ]);
                }
            }
            else
            {
                $icon=$SocialService->icon;
            }

            $data = array(
                'title'             => $request->title,
                'description'       => $request->description,
                'icon'              => $icon
                    );
            $SocialService->update($data);
            $data = Service::find($id);
            //
            $Redirect = '';
            return response()->json([
                'success' => true,
                'message' => 'Service updated successfully',
                'data' => $data
            ]);
        }
    }




    /**
     * change service status.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changestatus(Request $request)
    {
        if ($request->ajax())
        {
            $data = array('status' => $request->status );
            $Update =Service::where('id', '=', $request->id)->update($data);

            if($Update){
                return response()->json([
                    'success'=>true,
                    'message'=>['Status successfully change'],
                    'data'=>[
                        'redirect'=>'/services/',
                        'reload'=>true,
                    ]
                ]);
            }
            else{
                return response()->json([
                    'success'=>false,
                    'message'=>['Error for change status'],
                    'data'=>[
                        'redirect'=>'',
                    ]
                ]);
            }
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $Delete =Service::where(['id'=>$request->id])->delete();
        $Redirect = '/services';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);
    }
}
