<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Website\Setting;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class SettingController extends Controller
{
    public function index(Request $request)
    {
      $Setting = Setting::select(['id','twitter','facebook','instagram','youtube','linkedin','status'])->orderBy('id','desc')->paginate(10);
        if ($request->ajax()) {
            $sort_by = $request->get('sortby');
            $sort_type = $request->get('sorttype');
            $query = $request->get('query');
            if(!empty($query) && !empty($sort_by) && $query!=" ")
            {
              $Setting = Setting::query()->select(['id','twitter','facebook','instagram','youtube','linkedin','status'])
              ->where('twitter', 'like', '%'.$query.'%')
              ->orWhere('facebook', 'like', '%'.$query.'%')
              ->orderBy('id','desc')
              ->paginate($sort_by);
            }
            elseif($sort_by)
            {
              $Setting = Setting::select(['id','twitter','facebook','instagram','youtube','linkedin','status'])->orderBy('id','desc')->paginate($sort_by);
            }
            else
            {
              $Setting = Setting::select(['id','twitter','facebook','instagram','youtube','linkedin','status'])->orderBy('id','desc')->paginate(10);
            }   
          return view('website-setting.settings.table', compact('Setting'));
        }
        else
        {
            return view('website-setting.settings.index',compact('Setting'));
        }
        
    }

    
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('website-setting.settings.create');
    }

    
    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        if($request->isMethod('post'))
        {
           // return $request;
            $validator =  Validator::make($request->all(),[
                'facebook' => 'required',
            ]);
            if($validator->fails())
            {
                return response()->json(['success'=>false,'message'=>$validator->errors()->all()]);
            }
            else{

                $path="upload/logos";
                if(!empty($request->logo))
                {
                  $logo=uploadImage($path,$request->logo);
                }
                else
                {
                  $logo="";
                } 


                $path="upload/favicon";
                if(!empty($request->favicon))
                {
                  $favicon=uploadImage($path,$request->favicon);
                }
                else
                {
                  $favicon="";
                } 

                $path="upload/footer_logo";
                if(!empty($request->footer_logo))
                {
                  $footer_logo=uploadImage($path,$request->footer_logo);
                }
                else
                {
                  $footer_logo="";
                } 


                $Category = Setting::create([
                                'company_name' => $request->company_name,
                                'company_about' => $request->company_about,
                                'whatsapp_number' => $request->whatsapp_number,
                                'copy_rights'=> $request->copy_rights,
                                'logo' => $logo,
                                'favicon' => $favicon,
                                'footer_logo' => $footer_logo,
                                'facebook' => $request->facebook,
                                'twitter' => $request->twitter,
                                'instagram' => $request->instagram,
                                'youtube' => $request->youtube,
                                'linkedin' => $request->linkedin,
                            ]);
                //
                $Redirect = '/settings';
                return response()->json([
                    'success'=>true,
                    'message'=>['Setting successfully created'],
                    'data'=>[
                    'redirect'=>$Redirect,
                    'reload'=>true,
                    ]
                ]);
            }
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id,Request $request)
    {
        $Setting = Setting::find($id);
        return view('website-setting.settings.edit')->with(['Setting'=>$Setting]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id,Request $request)
    {
        $validator =  Validator::make($request->all(),[
          'facebook' => 'required',
        ]);
        if($validator->fails())
        {
            return response()->json(['success'=>false,'message'=>$validator->errors()->all()]);
        }
        else{
            $Settings=Setting::find($id);

            $path="upload/logos";
                if(!empty($request->logo))
                {
                  $logo=uploadImage($path,$request->logo);
                }
                else
                {
                  $logo=$Settings->logo;
                } 


                $path="upload/favicon";
                if(!empty($request->favicon))
                {
                  $favicon=uploadImage($path,$request->favicon);
                }
                else
                {
                  $favicon=$Settings->favicon;
                } 

                $path="upload/footer_logo";
                if(!empty($request->footer_logo))
                {
                  $footer_logo=uploadImage($path,$request->footer_logo);
                }
                else
                {
                  $footer_logo=$Settings->footer_logo;
                } 
            $data = array(
                'company_name' => $request->company_name,
                'company_about' => $request->company_about,
                'whatsapp_number' => $request->whatsapp_number,
                'copy_rights'=> $request->copy_rights,
                'logo' => $logo,
                'favicon' => $favicon,
                'footer_logo' => $footer_logo,
                'facebook' => $request->facebook,
                'twitter' => $request->twitter,
                'instagram' => $request->instagram,
                'youtube' => $request->youtube,
                'linkedin' => $request->linkedin,
              );
            $Settings->update($data);
            $Redirect = '/settings';
            return response()->json([
                'success'=>true,
                'message'=>['Setting successfully Update'],
                'data'=>[
                'redirect'=>$Redirect,
                'reload'=>false,
                ]
            ]);
        }
    }
    
    /**
     * change service status.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changestatus(Request $request)
    {
        if ($request->ajax())
        {
            $data = array('status' => $request->status );
            $Update = Setting::where('id', '=', $request->id)->update($data);

            if($Update){
                return response()->json([
                    'success'=>true,
                    'message'=>['Setting successfully change'],
                    'data'=>[
                        'redirect'=>'',
                        'reload'=>true,
                    ]
                ]);
            }
            else{
                return response()->json([
                    'success'=>false,
                    'message'=>['Error for change status'],
                    'data'=>[
                        'redirect'=>'',
                    ]
                ]);
            }
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function delete(Request $request)
    {
        $Delete = Setting::where(['id'=>$request->id])->delete();
        $Redirect = '/settings';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);
    }
}
