<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Website\Slider;
use Illuminate\Http\Request;
use Validator;

class SliderController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:website-slider-list|website-slider-create|website-slider-edit|website-slider-delete', ['only' => ['index','store','list']]);
    }
    public function index(Request $request)
    {
      $Slider = Slider::select([
        'id',
        'title',
        'sub_title',
        'content',
        'image',
        'status',
        'priority_status',
      ]);


            $sort_by    = $request->get('sortby') ?? 10;
            $sort_type  = $request->get('sorttype');
            $query      = $request->get('query');
            if(!empty($query) && !empty($sort_by) && $query!=" ")
            {
               $Slider->where('title', 'like', '%'.$query.'%')
                      ->orWhere('sub_title', 'like', '%'.$query.'%');
            }
            $Sliders =$Slider->orderBy('id','desc')->paginate($sort_by);

        if ($request->ajax()) {
            return view('website-setting.slider.table', compact('Sliders'));
        }
        else
        {
            return view('website-setting.slider.index',compact('Sliders'));
        }

    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('website-setting.slider.create');
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        if($request->isMethod('post'))
        {
           // return $request;
            $validator =  \Validator::make($request->all(),[
                'title' => 'required',
            ]);
            if($validator->fails())
            {
                return response()->json(['success'=>false,'message'=>$validator->errors()->all()]);
            }
            else{
                if ($request->hasFile('slider_image')) {
                    $path               = "assets/slider";
                    $response = uploadImage($path,$request->slider_image);

                    if ($response['status'] == true)
                    {
                        $image = $response['file_name'];
                    }
                }
                    else
                    {
                        $image = '';
                    }


                     if ($request->hasFile('images')) {
                        $url        =\Str::slug($request->title);
                        $path       ="upload/content/".$url;
                        $response = uploadImage($path,$request->images);

                        if ($response['status'] == true)
                        {
                            $files = $response['file_name'];
                        }
                        else
                        {
                            return response()->json([
                                'success' => false,
                                'message' => $response['message'],
                                'data'    => []
                            ]);
                        }
                    }
                    else
                    {
                        $files='';
                    }
                $Category = Slider::create([
                                'title' => $request->title,
                                'company_id' => auth()->user()->company_id,
                                'sub_title' => $request->sub_title,
                                'image' => $image,
                                'btn2_text'=>$request->btn2_text,
                                'btn2_enquiry_link'=>$request->btn2_enquiry_link,
                                'btn_enquiry_link'=>$request->btn_enquiry_link,
                                'btn_text'=>$request->btn_text,
                                'status' => '1',
                                'priority_status'=>$request->priority_status,
                            ]);
                //
                $Redirect = route('sliders.index');
                return response()->json([
                    'success'=>true,
                    'message'=>['Slider successfully created'],
                    'data'=>[
                    'redirect'=>$Redirect,
                    'reload'=>true,
                    ]
                ]);
            }
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit(Slider $Slider)
    {
        $Slider = Slider::where(['id'=>$Slider->id])->first();
        //
        return view('website-setting.slider.edit')->with(['Slider'=>$Slider]);
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id,Request $request)
    {
        $validator =  Validator::make($request->all(),[
            'title' => 'required',
        ]);
        if($validator->fails())
        {
            return response()->json(['success'=>false,'message'=>$validator->errors()->all()]);
        }
        else{
            $Slider=Slider::find($id);


                if ($request->hasFile('slider_image'))
                {
                            $path               = "assets/slider";
                            $response = uploadImage($path,$request->slider_image,$Slider->image);

                            if ($response['status'] == true)
                            {
                                $image = $response['file_name'];
                            }
                }
                else
                {
                    $image = $Slider->image;
                }
            $data = array(
                    'title' => $request->title,
                    'sub_title' => $request->sub_title,
                    'image' => $image,
                    'btn2_text'=>$request->btn2_text,
                    'btn2_enquiry_link'=>$request->btn2_enquiry_link,
                    'btn_enquiry_link'=>$request->btn_enquiry_link,
                    'btn_text'=>$request->btn_text,
                    'priority_status'=>$request->priority_status,
                    );
                    $Slider->update($data);
            //
            $Redirect = '';
            return response()->json([
                'success'=>true,
                'message'=>['Slider successfully Update'],
                'data'=>[
                'redirect'=>'/sliders/',
                'reload'=>false,
                ]
            ]);
        }
    }

    /**
     * change service status.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changestatus(Request $request)
    {
        if ($request->ajax())
        {
            $data = array('status' => $request->status );
            $Update = Slider::where('id', '=', $request->id)->update($data);

            if($Update){
                return response()->json([
                    'success'=>true,
                    'message'=>['Status successfully change'],
                    'data'=>[
                        'redirect'=>'/sliders/',
                        'reload'=>true,
                    ]
                ]);
            }
            else{
                return response()->json([
                    'success'=>false,
                    'message'=>['Error for change status'],
                    'data'=>[
                        'redirect'=>'',
                    ]
                ]);
            }
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $Delete = Slider::find($request->id);

        $old_image = $Delete->image;

        if ($old_image != '') {
            deleteImage($old_image);
        }

        $Delete->delete();
        $Redirect = '/sliders';
        return response()->json([
            'success'=>true,
            'message'=>['Deleted successfully'],
            'data'=>[
            'redirect'=>$Redirect,
            ]
        ]);
    }
}
