<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Website\SocialMedia;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class SocialMediaController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:website-social-media-list|website-social-media-create|website-social-media-edit|website-social-media-delete', ['only' => ['index','store','list']]);
    }
    public function index(Request $request)
    {
        $SocialSocialMedias = SocialMedia::select([
            'id',
            'media_name',
            'code',
            'status'
        ]);

        $sort_by        = $request->get('sortby') ?? 10;
        $sort_type      = $request->get('sorttype');
        $query          = $request->get('query');
        if (!empty($query) && !empty($sort_by) && $query != " ") {
            $SocialSocialMedias->where('media_name', 'like', '%' . $query . '%')
                ->orWhere('code', 'like', '%' . $query . '%');
        }
        $SocialSocialMedia = $SocialSocialMedias->orderBy('id', 'desc')->paginate($sort_by);
        if ($request->ajax()) {
            return view('website-setting.social-media.table', compact('SocialSocialMedia'));
        } else {
            return view('website-setting.social-media.index', compact('SocialSocialMedia'));
        }
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('website-setting.social-media.create');
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = \Validator::make($request->all(), ['media_name' => 'required']);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data               = $request->except(['_token']);
        $data['company_id'] = auth()->user()->company_id;

        $data = SocialMedia::create($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Social Media created successfully',
                'data' => $data
            ]);
        }

        return redirect()->route('social-media.index')
            ->with('success', 'Social Media created successfully');
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, Request $request)
    {
        $SocialSocialMedia = SocialMedia::where(['id' => $id])->first();
        //
        return view('website-setting.social-media.edit')->with(['SocialSocialMedia' => $SocialSocialMedia]);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, Request $request)
    {
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id, Request $request)
    {

        $validator = \Validator::make($request->all(), ['media_name' => 'required']);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except(['_token', '_method']);
        $data = SocialMedia::whereId($id)->update($data);
        $data = SocialMedia::find($id);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Social Media updated successfully',
                'data' => $data
            ]);
        }
        return redirect()->route('social-media.index')
            ->with('success', 'Social Media updated successfully');
    }




    /**
     * change service status.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changestatus(Request $request)
    {
        if ($request->ajax()) {
            $data = array('status' => $request->status);
            $Update = SocialMedia::where('id', '=', $request->id)->update($data);

            if ($Update) {
                return response()->json([
                    'success' => true,
                    'message' => ['Status successfully change'],
                    'data' => [
                        'redirect' => '/social-media/',
                        'reload' => true,
                    ]
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => ['Error for change status'],
                    'data' => [
                        'redirect' => '',
                    ]
                ]);
            }
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $Delete = SocialMedia::where(['id' => $request->id])->delete();
        $Redirect = '/social-media';
        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data' => [
                'redirect' => $Redirect,
            ]
        ]);
    }
}
