<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Website\Team;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class TeamController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:website-teams-list|website-teams-create|website-teams-edit|website-teams-delete', ['only' => ['index','store','list']]);
    }

    public function index(Request $request)
    {
        $team = Team::select([
            'id',
            'name',
            'designation',
            'profile',
            'status',
            'priority',
        ]);

        $sort_by        = $request->get('sortby') ?? 10;
        $sort_type      = $request->get('sorttype');
        $query          = $request->get('query');
        if (!empty($query) && !empty($sort_by) && $query != " ") {

            $team->where('name', 'like', '%' . $query . '%');
        }
        $teams = $team->orderBy('id', 'desc')->paginate($sort_by);
        if ($request->ajax()) {
            return view('website-setting.team.table', compact('teams'));
        } else {
            return view('website-setting.team.index', compact('teams'));
        }
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $priority    = Team::max('priority');
        $priority    = $priority != '' ? $priority : 0;

        return view('website-setting.team.create', compact('priority'));
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        if ($request->isMethod('post')) {
            // return $request;
            $validator =  Validator::make($request->all(), [
                'name'            => 'required',
                'designation'      =>  'required'
            ]);
            if ($validator->fails()) {
                return response()->json(['success' => false, 'message' => $validator->errors()->all()]);
            } else {

                if ($request->hasFile('profile')) {
                    $url        = \Str::slug($request->name);
                    $path       = "upload/team/" . $url . '/' . date('Y') . '/' . date('m');
                    $response = uploadImage($path, $request->profile);

                    if ($response['status'] == true) {
                        $profile = $response['file_name'];
                    } else {
                        return response()->json([
                            'success' => false,
                            'message' => $response['message'],
                            'data'    => []
                        ]);
                    }
                } else {
                    $profile = '';
                }

                $Category = Team::create([
                    'name'        => $request->name,
                    'priority'        => $request->priority,
                    'designation'     => $request->designation,
                    'profile'      => $profile,
                ]);
                //
                $Redirect = '/teams/';
                return response()->json([
                    'success' => true,
                    'message' => ['Team successfully created'],
                    'data' => $Category
                ]);
            }
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, Request $request)
    {
        $team = Team::where(['id' => $id])->first();
        //
        return view('website-setting.team.edit')->with(['team' => $team]);
    }


    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id, Request $request)
    {
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id, Request $request)
    {
        $validator =  Validator::make($request->all(), [
            'name'            => 'required',
            'designation'      =>  'required'
        ]);
        if ($validator->fails()) {
            return response()->json(['success' => false, 'message' => $validator->errors()->all()]);
        } else {
            $team = Team::find($id);
            $url        = \Str::slug($request->name);
            if ($request->hasFile('profile')) {
                $path       = "upload/team/" . $url . '/' . date('Y') . '/' . date('m');
                $response = uploadImage($path, $request->profile);

                if ($response['status'] == true) {
                    $profile = $response['file_name'];
                } else {
                    return response()->json([
                        'success' => false,
                        'message' => $response['message'],
                        'data'    => []
                    ]);
                }
            } else {
                $profile = $team->profile;
            }

            $data = array(
                'name'          => $request->name,
                'designation'   => $request->designation,
                'priority'      => $request->priority,
                'profile'       => $profile,
            );
            $team->update($data);
            //
            $teams = Team::find($id);
            $Redirect = '';
            return response()->json([
                'success' => true,
                'message' => ['Teams successfully Update'],
                'data' => $teams
            ]);
        }
    }




    /**
     * change ClientSay status.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changestatus(Request $request)
    {
        if ($request->ajax()) {
            $data = array('status' => $request->status);
            $Update = Team::where('id', '=', $request->id)->update($data);

            if ($Update) {
                return response()->json([
                    'success' => true,
                    'message' => ['Status successfully change'],
                    'data' => [
                        'redirect' => '/teams/',
                        'reload' => true,
                    ]
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => ['Error for change status'],
                    'data' => [
                        'redirect' => '',
                    ]
                ]);
            }
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $Delete = Team::where(['id' => $request->id])->delete();
        $Redirect = '/teams';
        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data' => [
                'redirect' => $Redirect,
            ]
        ]);
    }
}
