<?php

namespace App\Http\Controllers\Website;

use App\Http\Controllers\Controller;
use App\Models\Website\TblVideoGallery;
use Illuminate\Http\Request;
use Validator;

class VideoGalleryController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:website-video-gallery-list|website-video-gallery-create|website-video-gallery-edit|website-video-gallery-delete', ['only' => ['index','store','list']]);
    }
    public function index(Request $request)
    {
        $TblVideoGallerys = TblVideoGallery::select(['id', 'title', 'description', 'video_url', 'video_id', 'cover_pic', 'status', 'priority']);
        $sort_by        = $request->get('sortby') ?? 10;
        $sort_type      = $request->get('sorttype');
        $query          = $request->get('query');
        if (!empty($query) && !empty($sort_by) && $query != " ") {

            $TblVideoGallerys->where('title', 'like', '%' . $query . '%')
                ->orWhere('description', 'like', '%' . $query . '%');
        }
        $TblVideoGallery = $TblVideoGallerys->orderBy('id', 'desc')->paginate($sort_by);
        if ($request->ajax()) {
            return view('website-setting.videos-gallery.table', compact('TblVideoGallery'));
        } else {
            return view('website-setting.videos-gallery.index', compact('TblVideoGallery'));
        }
    }


    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        return view('website-setting.videos-gallery.create');
    }


    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {

        if ($request->isMethod('post')) {
            // return $request;
            $validator =  Validator::make($request->all(), [
                'title' => 'required',
                'cover_pic' => 'required|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
            ]);
            if ($validator->fails()) {
                return response()->json(['success' => false, 'message' => $validator->errors()->all()]);
            } else {


                if ($request->hasFile('cover_pic')) {
                    $url        = \Str::slug($request->title);
                    $path       = "upload/video_gallery/" . $url . '/' . date('Y') . '/' . date('m');
                    $response   = uploadImage($path, $request->cover_pic);

                    if ($response['status'] == true) {
                        $image = $response['file_name'];
                    } else {
                        return response()->json([
                            'success' => false,
                            'message' => $response['message'],
                            'data'    => []
                        ]);
                    }
                } else {
                    $image = '';
                }
                $Category = TblVideoGallery::create([
                    'title'       => $request->title,
                    'description' => $request->description,
                    'cover_pic'   => $image,
                    'company_id'  => auth()->user()->company_id,
                    'priority'    => $request->priority,
                    'video_url'   => $request->video_url,
                ]);
                //
                $Redirect = route('videos-gallery.index');
                return response()->json([
                    'success' => true,
                    'message' => ['Video Gallery successfully created'],
                    'data' => [
                        'redirect' => $Redirect,
                        'reload' => true,
                    ]
                ]);
            }
        }
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id, Request $request)
    {
        $TblVideoGallery = TblVideoGallery::where(['id' => $id])->first();
        //
        return view('website-setting.videos-gallery.edit')->with(['TblVideoGallery' => $TblVideoGallery]);
    }



    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update($id, Request $request)
    {
        $validator =  Validator::make($request->all(), [
            'title' => 'required',
        ]);
        if ($validator->fails()) {
            return response()->json(['success' => false, 'message' => $validator->errors()->all()]);
        } else {
            $TblVideoGallery = TblVideoGallery::find($id);

            if ($request->hasFile('cover_pic')) {
                $url        = \Str::slug($request->title);
                $path       = "upload/video_gallery/" . $url . '/' . date('Y') . '/' . date('m');
                $response   = uploadImage($path, $request->cover_pic, $TblVideoGallery->cover_pic);

                if ($response['status'] == true) {
                    $image = $response['file_name'];
                } else {
                    return response()->json([
                        'success' => false,
                        'message' => $response['message'],
                        'data'    => []
                    ]);
                }
            } else {
                $image = $TblVideoGallery->cover_pic;
            }

            $data = array(
                'title'       => $request->title,
                'description' => $request->description,
                'cover_pic'   => $image,
                'company_id'  => auth()->user()->company_id,
                'priority'    => $request->priority,
                'video_url'   => $request->video_url,
            );
            $TblVideoGallery->update($data);
            //
            $Redirect = '';
            return response()->json([
                'success' => true,
                'message' => ['Video Gallery successfully Update'],
                'data' => [
                    'redirect' => route('videos-gallery.index'),
                    'reload' => false,
                ]
            ]);
        }
    }




    /**
     * change service status.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function changestatus(Request $request)
    {
        if ($request->ajax()) {
            $data = array('status' => $request->status);
            $Update = TblVideoGallery::where('id', '=', $request->id)->update($data);

            if ($Update) {
                return response()->json([
                    'success' => true,
                    'message' => ['Status successfully change'],
                    'data' => [
                        'redirect' => '/video-gallery/',
                        'reload' => true,
                    ]
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => ['Error for change status'],
                    'data' => [
                        'redirect' => '',
                    ]
                ]);
            }
        }
    }
    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $Delete = TblVideoGallery::where(['id' => $request->id])->delete();
        $Redirect = '/videos-gallery';
        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data' => [
                'redirect' => $Redirect,
            ]
        ]);
    }
}
