<?php

namespace App\Http\Controllers\Workplace;

use App\Http\Controllers\Controller;
use App\Models\BudgetType;
use App\Models\ProjectBudget;
use App\Models\Projects;
use Illuminate\Http\Request;

class ProjectBudgetsController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:project-budget-list', ['only' => ['index']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {
        // $data = ProjectBudget::select(
        //     'id',
        //     'projects_id',
        //     'budget_type_id',
        //     'amount',
        //     'status'
        // )
        // ->with('getProject')
        // ->with('getBudget');

        // if ($request->ajax()) {
        //     $sort_by      = $request->get('sortby') ?? 10;
        //     $sort_type    = $request->get('sorttype');
        //     $search_query = $request->get('query');

        //     $data = $data->when(!empty($search_query), function ($query) use ($search_query) {
        //         return $query->where('name', 'like', '%'.$search_query.'%');
        //     })
        //     ->orderBy('id','ASC')
        //     ->groupBy('id')
        //     ->paginate($sort_by);

        //     return view('project-budgets.table', compact('data'));
        // } else {
        //     $data = $data->groupBy('id')
        //         ->orderBy('id','ASC')
        //         ->paginate(10);

        //     return view('project-budgets.index',compact('data'));
        // }
    }

    public function list(Request $request)
    {

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $project    = Projects::select('id','title')->get();
        $budgetType = BudgetType::select('id','name')->where('status',1)->get();
        return view('project-budgets.create',compact('project','budgetType'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'budget_type_id' => 'required'
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except(['_token']);

        $data = ProjectBudget::create($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Project Budget created successfully',
                'data' => $data
            ]);
        }

        return redirect()->route('project-budget.index')
            ->with('success', 'Project Budget created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data       = ProjectBudget::find($id);
        $project    = Projects::select('id','title')->get();
        $budgetType = BudgetType::select('id','name')->where('status',1)->get();
        return view('project-budgets.edit', compact('data','project','budgetType'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = \Validator::make($request->all(), [
            'budget_type_id' => 'required'
    ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except(['_token', '_method']);
        $data = ProjectBudget::whereId($id)->update($data);
        $data = ProjectBudget::find($id);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Project Budget updated successfully',
                'data' => $data
            ]);
        }
        return redirect()->route('project-budgets.index')
            ->with('success', 'Project Budget updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = ProjectBudget::find($request->id);

        ProjectBudget::find($request->id)->delete();

        $Redirect = 'project-budgets';

        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data' => [
                'redirect' => $Redirect,
            ]
        ]);
    }


    public function changeStatus(Request $request)
    {
        if ($request->ajax()) {
            $data   = array('status' => $request->status);
            $Update = ProjectBudget::where('id', '=', $request->id)->update($data);

            if ($Update) {
                return response()->json([
                    'success' => true,
                    'message' => ['Project Budget status successfully change'],
                    'data' => [
                        'redirect' => '/tags/',
                        'reload' => true,
                    ]
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => ['Error for change status'],
                    'data' => [
                        'redirect' => '',
                    ]
                ]);
            }
        }
    }
}
