<?php

namespace App\Http\Controllers\Workplace;

use App\Http\Controllers\Controller;
use App\Models\ProjectRequirement;
use App\Models\ProjectRequirements;
use App\Models\Projects;
use App\Models\ProjectType;
use Illuminate\Http\Request;

class ProjectRequirementsController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:project-requirement-list', ['only' => ['index']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {

    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $project     = Projects::select('id','title')->get();
        $projectType = ProjectType::select('id','title')->get();
        return view("project-requirements.create",compact("project",'projectType'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'features' => 'required',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except(['_token']);

        $data = ProjectRequirement::create($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Project Requirments created successfully',
                'data' => $data
            ]);
        }

        return redirect()->route('project-Requirments.index')
            ->with('success', 'Project Requirments created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data        = ProjectRequirement::find($id);
        $project     = Projects::select('id','title')->get();
        $projectType = ProjectType::select('id','title')->get();
        return view("project-requirements.edit",compact("project",'projectType','data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = \Validator::make($request->all(), [
            'features'      => 'required',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except
        ([
            '_token',
            '_method'
        ]);
        $data = ProjectRequirement::whereId($id)->update($data);
        $data = ProjectRequirement::find($id);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Project Requirments updated successfully',
                'data'    => $data
            ]);
        }

        return redirect()->route('project-requirments.index')
            ->with('success', 'Project Requirments updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = ProjectRequirement::find($request->id);

        ProjectRequirement::find($request->id)->delete();

        $Redirect = 'project-requirments';

        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data' => [
                'redirect' => $Redirect,
            ]
        ]);
    }
}
