<?php

namespace App\Http\Controllers\Workplace;

use App\Http\Controllers\Controller;
use App\Models\ProjectTeam;
use App\Models\User;
use Illuminate\Http\Request;

class ProjectTeamsController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:project-team-list', ['only' => ['index']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index(Request $request)
    {

    }
    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $user_id    = User::select('id','name')->where('status',1)->get();

        return view('project-teams.create',compact('user_id'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        $validator = \Validator::make($request->all(), [
            'team_user_id' => 'required|unique:project_teams,team_user_id,NULL,id,deleted_at,NULL',
            'role_in_project' => 'required',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

        return redirect()->back()->with('error', $validator->getMessageBag()->first());

        }

        $data = $request->except([
            '_token',
            'assign_date',
            'release_date'
        ]);

        $data['release_date'] = $request->release_date != '' && $request->release_date != '0000-00-00' &&  $request->release_date != Null ? date('Y-m-d', strtotime($request->release_date)) : null;
        $data['assign_date'] = $request->assign_date != '' && $request->assign_date != '0000-00-00' &&  $request->assign_date != Null ? date('Y-m-d', strtotime($request->assign_date)) : null;

        $data = ProjectTeam::create($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Project Team created successfully',
                'data' => $data
            ]);
        }

        return redirect()->route('project-teams.index')
            ->with('success', 'Project Team created successfully');
    }

    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data       = ProjectTeam::find($id);
        $user_id    = User::select('id','name')->where('status',1)->get();
        return view('project-teams.edit', compact('data','user_id'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = \Validator::make($request->all(), [
            'team_user_id'    => 'required|unique:project_teams,team_user_id,' . $id,
            'role_in_project' => 'required',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token',
            '_method',
            'assign_date',
            'release_date',
        ]);

        $data['assign_date']      = date('Y-m-d', strtotime($request->assign_date));
        $data['release_date']      = date('Y-m-d', strtotime($request->release_date));

        $data = ProjectTeam::whereId($id)->update($data);
        $data = ProjectTeam::find($id);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Project Team updated successfully',
                'data' => $data
            ]);
        }
        return redirect()->route('project-teams.index')
            ->with('success', 'Project Team updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request)
    {
        $data = ProjectTeam::find($request->id);

        ProjectTeam::find($request->id)->delete();

        $Redirect = 'project-teams';

        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data' => [
                'redirect' => $Redirect,
            ]
        ]);
    }


    public function changeStatus(Request $request)
    {
        if ($request->ajax()) {
            $data   = array('status' => $request->status);
            $Update = ProjectTeam::where('id', '=', $request->id)->update($data);

            if ($Update) {
                return response()->json([
                    'success' => true,
                    'message' => ['Project Team status successfully change'],
                    'data' => [
                        'redirect' => '/tags/',
                        'reload' => true,
                    ]
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => ['Error for change status'],
                    'data' => [
                        'redirect' => '',
                    ]
                ]);
            }
        }
    }

    public function changeManager(Request $request)
    {
        if ($request->ajax()) {
            $data   = array('is_manager' => $request->status);
            $Update = ProjectTeam::where('id', '=', $request->id)->update($data);

            if ($Update) {
                return response()->json([
                    'success' => true,
                    'message' => ['Is Manger status successfully change'],
                    'data' => [
                        'redirect' => '/classes/',
                        'reload' => true,
                    ]
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => ['Error for change status'],
                    'data' => [
                        'redirect' => '',
                    ]
                ]);
            }
        }
    }
}
