<?php

namespace App\Http\Controllers\Workplace;

use App\Http\Controllers\Controller;
use App\Models\Task;
use App\Models\TaskAttachment;
use Illuminate\Http\Request;

class TaskAttachmentsController extends Controller
{
    function __construct()
    {
        $this->middleware('permission:task-attachment-list', ['only' => ['index']]);
    }
    /**
     * Display a listing of the resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        //
    }

    /**
     * Show the form for creating a new resource.
     *
     * @return \Illuminate\Http\Response
     */
    public function create()
    {
        $task = Task::select('id','title')->get();
        return view('task-attachments.create',compact('task'));
    }

    /**
     * Store a newly created resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function store(Request $request)
    {
        // dd($request->all());
        $validator = \Validator::make($request->all(), [
            // 'title' => 'required|unique:lms_subjects',
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }

            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data = $request->except([
            '_token'
        ]);

        if ($request->hasFile('uploaded_file')) {
            $path          = 'task_attachments/' . date('Y') . '/' . date('M');
            $response      = uploadImage($path, $request->uploaded_file);

            if ($response['status'] == true) {
                $data['uploaded_file'] = $response['file_name'];
            } else {
                if ($request->ajax()) {
                    return response()->json([
                        'success' => false,
                        'message' => $response['message'],
                        'data'    => []
                    ]);
                }

                return redirect()->back()->with('error', $response['message']);
            }
        }

        $data = TaskAttachment::create($data);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Task Attachments created successfully',
                'data' => $data
            ]);
        }

        return redirect()->route('task-attachments.index')
            ->with('success', 'Task Attachments created successfully');
    }


    /**
     * Display the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function show($id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function edit($id)
    {
        $data = TaskAttachment::find($id);

        return view('task-attachments.edit', compact('data'));
    }

    /**
     * Update the specified resource in storage.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function update(Request $request, $id)
    {
        $validator = \Validator::make($request->all(), [
            'title'=>'required|unique:task_attachments,title'
        ]);

        if ($validator->fails()) {
            if ($request->ajax()) {
                return response()->json([
                    'success' => false,
                    'message' => $validator->getMessageBag()->first(),
                    'data'    => []
                ]);
            }
            return redirect()->back()->with('error', $validator->getMessageBag()->first());
        }

        $data   = $request->except(['_token', 'uploaded_file', '_method']);
        $record = TaskAttachment::find($id);

        if ($request->hasFile('uploaded_file')) {
            $path          = 'subjects/' . date('Y') . '/' . date('M');
            $response      = uploadImage($path, $request->uploaded_file, $record->uploaded_file);

            if ($response['status'] == true) {
                $data['uploaded_file'] = $response['file_name'];
            } else {
                if ($request->ajax()) {
                    return response()->json([
                        'success' => false,
                        'message' => $response['message'],
                        'data'    => []
                    ]);
                }

                return redirect()->back()->with('error', $response['message']);
            }
        }

        $data = TaskAttachment::whereId($id)->update($data);
        $data = TaskAttachment::find($id);

        if ($request->ajax()) {
            return response()->json([
                'success' => true,
                'message' => 'Subject updated successfully',
                'data' => $data
            ]);
        }
        return redirect()->route('subjects.index')
            ->with('success', 'Subject updated successfully');
    }

    /**
     * Remove the specified resource from storage.
     *
     * @param  int  $id
     * @return \Illuminate\Http\Response
     */
    public function destroy(Request $request, $id)
    {
        $data = TaskAttachment::find($request->id);

        if ($data->uploaded_file != '') {
            deleteImage($data->uploaded_file);
        }

        TaskAttachment::find($request->id)->delete();

        $Redirect = 'task-attachments';

        return response()->json([
            'success' => true,
            'message' => ['Deleted successfully'],
            'data' => [
                'redirect' => $Redirect,
            ]
        ]);
    }
    public function changeStatus(Request $request)
    {
        if ($request->ajax()) {
            $data = array('status' => $request->status);
            $Update = TaskAttachment::where('id', '=', $request->id)->update($data);

            if ($Update) {
                return response()->json([
                    'success' => true,
                    'message' => ['Task Attachment successfully change'],
                    'data' => [
                        'redirect' => '/task-attachments/',
                        'reload' => true,
                    ]
                ]);
            } else {
                return response()->json([
                    'success' => false,
                    'message' => ['Error for change status'],
                    'data' => [
                        'redirect' => '',
                    ]
                ]);
            }
        }
    }
}
