<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class CompanyRegistrationRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, mixed>
     */
    public function rules()
    {
        return [
            'name'         =>'required',
            'email'        =>'required|email',
            'branch_name'  =>'required',
            'branch_code'  =>'required',
            'office_type'  =>'required',
            'country_id'   =>'required',
            'phone_number' =>'required|unique:companies|max:16|min:10',
        ];
    }
}
