<?php

namespace App\Imports;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Concerns\ToModel;

class ImportLibraryAuthor implements ToModel
{
    /**
    * @param Collection $collection
    */
    public function model(array $row)
    {
        if (
            $row[0] != 'Author Name (required field)'
        ) {

            if ($row[0] != '') {

                if ($row[2] == '' || $row[2] == 'Active' || $row[2] == 'Inactive') {
                    $author_data = Session::get('AuthorData');
                    $exist_author_name = array_column($author_data, 0);

                    if (in_array($row[0], $exist_author_name)) {
                        $row['status'] = 'duplicate';
                        $author_data[] = $row;

                        Session::put('AuthorData', $author_data);
                    } else {
                        $row['status'] = true;
                        $author_data[] = $row;

                        Session::put('AuthorData', $author_data);
                    }
                } else {
                    throw new \Exception('Invalid Status.');
                }
            } else {
                throw new \Exception('Author name is required!');
            }
        }

        return;
    }
}
