<?php

namespace App\Imports;

use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Concerns\ToModel;


class ImportLibraryCategory implements ToModel
{
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function model(array $row)
    {
        if (
            $row[0] != 'Category Name (required field)'
        ) {

            if ($row[0] != '') {

                if ($row[2] == '' || $row[2] == 'Active' || $row[2] == 'Inactive') {
                    $category_data = Session::get('CategoryData');
                    $exist_category_name = array_column($category_data, 0);

                    if (in_array($row[0], $exist_category_name)) {
                        $row['status'] = 'duplicate';
                        $category_data[] = $row;

                        Session::put('CategoryData', $category_data);
                    } else {
                        $row['status'] = true;
                        $category_data[] = $row;

                        Session::put('CategoryData', $category_data);
                    }
                } else {
                    throw new \Exception('Invalid Status.');
                }
            } else {
                throw new \Exception('Category name is required!');
            }
        }

        return;
    }
}
