<?php

namespace App\Imports;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Concerns\ToModel;

class ImportLibraryEditor implements ToModel
{
    /**
    * @param Collection $collection
    */
    public function model(array $row)
    {
        if (
            $row[0] != 'Editor Name (required field)' 
        ) {

            if ($row[0] != '') {

                if ($row[1] == '' || $row[1] == 'Active' || $row[1] == 'Inactive') {
                    $editor_data = Session::get('EditorData');
                    $exist_editor_name = array_column($editor_data, 0);

                    if (in_array($row[0], $exist_editor_name)) {
                        $row['status'] = 'duplicate';
                        $editor_data[] = $row;

                        Session::put('EditorData', $editor_data);
                    } else {
                        $row['status'] = true;
                        $editor_data[] = $row;

                        Session::put('EditorData', $editor_data);
                    }
                } else {
                    throw new \Exception('Invalid Status.');
                }
            } else {
                throw new \Exception('Editor name is required!');
            }
        }

        return;
    }
}
