<?php

namespace App\Imports;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Concerns\ToCollection;
use Maatwebsite\Excel\Concerns\ToModel;

class ImportLibraryPublisher implements ToModel
{
    /**
    * @param Collection $collection
    */
    public function model(array $row)
    {
        if (
            $row[0] != 'Publisher Name (required field)'
        ) {

            if ($row[0] != '') {

                if ($row[3] == '' || $row[3] == 'Active' || $row[3] == 'Inactive') {
                    $publisher_data = Session::get('PublisherData');
                    $exist_publisher_name = array_column($publisher_data, 0);

                    if (in_array($row[0], $exist_publisher_name)) {
                        $row['status'] = 'duplicate';
                        $publisher_data[] = $row;

                        Session::put('PublisherData', $publisher_data);
                    } else {
                        $row['status'] = true;
                        $publisher_data[] = $row;

                        Session::put('PublisherData', $publisher_data);
                    }
                } else {
                    throw new \Exception('Invalid Status.');
                }
            } else {
                throw new \Exception('Publisher name is required!');
            }
        }

        return;
    }
}
