<?php

namespace App\Imports;

use Illuminate\Support\Collection;
use Illuminate\Support\Facades\Session;
use Maatwebsite\Excel\Concerns\ToModel;

class ImportLibraryTranslators implements ToModel
{
    /**
    * @param Collection $collection
    */
    public function model(array $row)
    {
        if (
            $row[0] != 'Translator Name (required field)' 
        ) {

            if ($row[0] != '') {

                if ($row[1] == '' || $row[1] == 'Active' || $row[1] == 'Inactive') {
                    $translator_data = Session::get('TranslatorsData');
                    $exist_translator_name = array_column($translator_data, 0);

                    if (in_array($row[0], $exist_translator_name)) {
                        $row['status'] = 'duplicate';
                        $translator_data[] = $row;

                        Session::put('TranslatorsData', $translator_data);
                    } else {
                        $row['status'] = true;
                        $translator_data[] = $row;

                        Session::put('TranslatorsData', $translator_data);
                    }
                } else {
                    throw new \Exception('Invalid Status.');
                }
            } else {
                throw new \Exception('Translator name is required!');
            }
        }

        return;
    }
}
