<?php

namespace App\Imports;

use Maatwebsite\Excel\Concerns\ToModel;
use Session;

class ImportSymptom implements ToModel
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function modelOld(array $row)
    {
       
        // Check if the row has at least 3 columns
        if (count($row) < 3) {
            // Optionally, you can log the error or skip this row
            return null;
        }
        
        // Ensure that the title column is not the header or empty
        if ($row[2] !== 'Symptom Title (required field)' && !empty($row[2])) {
            $symptoms_data      = Session::get('SymptomsData', []);
            $exist_symptom_name = array_column($symptoms_data, 2); // Use the correct index for the title

            if (in_array($row[2], $exist_symptom_name)) {
                // Skip duplicates
                return null;
            } else {
                // Add the row to the session data
                $symptoms_data[] = $row;
                Session::put('SymptomsData', $symptoms_data);
            }
        }

        return null;
    }

    public function model(array $row)
    {
       
        // Check if the row has at least 3 columns
        if (count($row) < 2) {
            // Optionally, you can log the error or skip this row
            return null;
        }
        
        // Ensure that the title column is not the header or empty
        if ($row[0] !== 'Diagnosis' && !empty($row[0])) {
            $symptoms_data      = Session::get('SymptomsData', []);
            $exist_symptom_name = array_column($symptoms_data, 2); // Use the correct index for the title

            if (in_array($row[0], $exist_symptom_name)) {
                // Skip duplicates
                return null;
            } else {
                // Add the row to the session data
                $symptoms_data[] = $row;
                Session::put('SymptomsData', $symptoms_data);
            }
        }

        return null;
    }
}
