<?php

namespace App\Imports;

use Maatwebsite\Excel\Concerns\ToModel;
use Session;

class ImportTestItemRange implements ToModel
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        if ($row[0] != 'Gender (Male, Female & Transgender)' &&
		    $row[1] != 'Min Age' &&
		    $row[2] != 'Max Age' &&
		    $row[3] != 'Age Factor (Hours, Days & Years)' &&
		    $row[4] != 'Min Value' &&
		    $row[5] != 'Max Value' &&
		    $row[6] != 'Report Output' &&
		    $row[7] != 'Special Case (Common, Pregnant Woman, Cancer Patient & Baby)' &&
		    $row[8] != 'Status (Active/Inactive)') {

		    if ($row[0] != '' &&
		        $row[1] != '' &&
		        $row[2] != '' &&
		        $row[3] != '' &&
		        $row[4] != '' &&
		        $row[5] != '' &&
		        $row[7] != '' ) {

		        if (
		            $row[0] == 'Male' ||
		            $row[0] == 'Female' ||
		            $row[0] == 'Transgender') {

		            if ($row[7] == 'Common' ||
		                $row[7] == 'Pregnant Woman' ||
		                $row[7] == 'Cancer Patient' ||
		                $row[7] == 'Baby') {

		                if ($row[3] == 'Hours' ||
		                    $row[3] == 'Days' ||
		                    $row[3] == 'Years') {

		                    if ($row[8] == '' || $row[8] == 'Active' || $row[8] == 'Inactive') {

		                        if (is_int($row[1]) && is_int($row[2]) && is_int($row[4]) && is_int($row[5])) {

		                            $test_item_normal_ranges_data = Session::get('TestItemNormalRangesData');

		                            if ($row[1] < $row[2]) {

		                                if ($row[4] < $row[5]) {
		                                    $test_item_normal_ranges_data[] = $row;

		                                    Session::put('TestItemNormalRangesData', $test_item_normal_ranges_data);
		                                } else {
		                                    throw new \Exception('Min Value should be less than Max Value.');
		                                }
		                            } else {
		                                throw new \Exception('Min Age should be less than Max Age.');
		                            }
		                        } else {
		                            throw new \Exception('Age and value must be integers.');
		                        }
		                    } else {
		                        throw new \Exception('Invalid Status.');
		                    }
		                } else {
		                    throw new \Exception('Invalid Age Factor.');
		                }
		            } else {
		                throw new \Exception('Invalid Special Case.');
		            }
		        } else {
		            throw new \Exception('Invalid Gender.');
		        }
		    } else {
		        throw new \Exception('All fields are required');
		    }
		}
    }
}