<?php

namespace App\Imports;

use Maatwebsite\Excel\Concerns\ToModel;
use Session;

class ImportTestUnit implements ToModel
{
    /**
    * @param array $row
    *
    * @return \Illuminate\Database\Eloquent\Model|null
    */
    public function model(array $row)
    {
        if ($row[0] != 'Test Unit Name (required field)' && 
            $row[1] != 'Description' && 
            $row[2] != 'Status (Active/Inactive)' ) {

            if ($row[0] != ''){

                if ($row[2] == '' || $row[2] == 'Active' || $row[2] == 'Inactive') {

                    $test_units_data = Session::get('TestUnitsData');
                    $exist_test_unit_name = array_column($test_units_data, 0);

                    if (in_array($row[0], $exist_test_unit_name)) {
                        $row['status'] = 'duplicate';
                        $test_units_data[] = $row;

                        Session::put('TestUnitsData', $test_units_data);
                    } else {
                        $row['status'] = true;
                        $test_units_data[] = $row;

                        Session::put('TestUnitsData', $test_units_data);
                    }
                } else {
                    throw new \Exception('Invalid Status.');
                }
            } else {
                throw new \Exception('Test Unit name is required!');
            }
        }

        return;
    }
}