<?php

namespace App\Imports;

use App\Models\Marketing;
use App\Models\Product;
use App\Models\IncentiveSlabDetail;
use Maatwebsite\Excel\Concerns\ToModel;
use Maatwebsite\Excel\Concerns\WithStartRow;
use Illuminate\Http\Request;

class MarketImport implements ToModel, WithStartRow
{
    protected $request;
    /**
     * @param array $row
     *
     * @return \Illuminate\Database\Eloquent\Model|null
     */
    public function __construct(Request $request)
    {
        $this->request = $request;
    }
    public function model(array $row)
    {
        $data = \Session::get('market_import') ?? [];
        
        $business = $this->request->input('business_category_id');
        
        $existingRecord = Marketing::where('gbp_link', $row[1])->first();
        
        if ($existingRecord) {
            $data['errorImport'] = $data['errorImport'] + 1;
            \Session::put('market_import', $data);

            return null;
        }

        $data['successImport'] =  $data['successImport'] + 1;

        \Session::put('market_import', $data);
        
        return new Marketing([
            'business_name'         => $row[0],
            'gbp_link'              => $row[1],
            'rating'                => $row[2],
            'total_review'          => $row[3],
            'address'               => $row[4],
            'website'               => $row[5],
            'phone_number'          => $row[6],
            'email'                 => $row[7],
            'claim_status'          => $row[8],
            'optimization_score'    => $row[9],
            'local_ads'             => $row[10],
            'paid_ads'              => $row[11],
            'google_ranking'        => $row[12],
            'pack_ranking'          => $row[13],
            'ai_suggested_services' => $row[14],
            'business_category_id'  => $business,
        ]);
       
    }

    public function startRow(): int
    {
        return 2;
    }
}
