<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AcJournalTransaction extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'transactions_no',
        'transaction_date',
        'module_id',
        'voucher_id',
        'voucher_type',
        'account_id',
        'transaction_type',
        'details_narration',
        'amount',
        'created_by',
        'company_id',
        'financial_year_id',
        'transactions_status'
    ];

    public function financialYear(){
        return $this->hasOne(FinancialYear::class,'financialyearid','financial_year_id');
    }

    public function company(){
        return $this->hasOne(Company::class,'id','company_id');
    }

    public function user(){
        return $this->hasOne(User::class,'id','created_by');
    }

    public function account(){
        return $this->hasOne(Account::class,'id','account_id');
    }

    public function module(){
        return $this->hasOne(MenuModelPermission::class,'id','module_id');
    }
}
