<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\HasOne;
use Illuminate\Database\Eloquent\SoftDeletes;

class AcReceiptDetail extends Model
{
    use HasFactory, SoftDeletes;

    protected $with = ['payment_mode'];
    protected $fillable =[
        'ac_receipt_id',
        'payment_mode_id',
        'transaction_mode_id',
        'voucher_master_id',
        'voucher_id',
        'voucher_type',
        'module_id',
        'account_id',
        'transaction_type',
        'details_narration',
        'amount',
        'created_by',
        'company_id',
        'transactions_status',
        'transaction_date',
        'transaction_referrence',
    ];

    public function payment_mode():HasOne
    {
        return $this->hasOne(PaymentMode::class, 'id', 'transaction_mode_id');
    }

    public function transaction_mode(){
        return $this->hasOne(Account::class,'id','payment_mode_id')->with('account_contact','first_account_address');
    }

    public function company(){
        return $this->hasOne(Company::class,'id','company_id');
    }

    public function user(){
        return $this->hasOne(User::class,'id','created_by');
    }

    public function account(){
        return $this->hasOne(Account::class,'id','account_id')->with('account_contact','first_account_address');
    }

    public function module(){
        return $this->hasOne(MenuModelPermission::class,'id','module_id');
    }

    public function voucherType(){
        return $this->hasOne(VoucherType::class,'code','voucher_type');
    }

    public function voucherTerm(){
        return $this->hasOne(VoucherTerm::class,'voucher_id','voucher_master_id')->where('status', '1')->orderBy('is_default','Desc');
    }

}
