<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccountAddress extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];

    public function address_type()
    {
        return $this->belongsTo(MasterType::class, 'address_type_id','id')->where('module_name', '=', 'ACCOUNT_ADDRESS_TYPE');
    }

    public function country()
    {
        return $this->belongsTo(Country::class);
    }

    public function state()
    {
        return $this->belongsTo(State::class);
    }

    public function city()
    {
        return $this->belongsTo(City::class);
    }
}
