<?php

namespace App\Models;

use App\Helpers\SiteHelper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccountAttachment extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];
    protected $appends = ['activation_date_formatted', 'renewal_date_formatted', 'expiry_date_formatted', 'file_url'];

    public function getActivationDateFormattedAttribute()
    {
        if (auth()->check() && $this->activation_date != '') {
            $auth_country = \App\Models\CompanyAddress::select('countries.*')
                ->leftjoin('countries', 'countries.id', 'companies_addresses.country_id')
                ->where('companies_addresses.company_id', \Auth::user()->company_id)
                ->first();

            $auth_currency = isset($auth_country) && isset($auth_country->currency_symbol)
                ? $auth_country->currency_symbol
                : 'USD';

            $auth_format = isset($auth_country) && isset($auth_country->formats)
                ? $auth_country->formats
                : 'm-d-Y';
            return date($auth_format, strtotime($this->activation_date));
        }
        return '';
    }

    public function getRenewalDateFormattedAttribute()
    {
        if (auth()->check() && $this->renewal_date != '') {
            $auth_country = \App\Models\CompanyAddress::select('countries.*')
                ->leftjoin('countries', 'countries.id', 'companies_addresses.country_id')
                ->where('companies_addresses.company_id', \Auth::user()->company_id)
                ->first();

            $auth_currency = isset($auth_country) && isset($auth_country->currency_symbol)
                ? $auth_country->currency_symbol
                : 'USD';

            $auth_format = isset($auth_country) && isset($auth_country->formats)
                ? $auth_country->formats
                : 'm-d-Y';
            return date($auth_format, strtotime($this->renewal_date));
        }
        return '';
    }

    public function getExpiryDateFormattedAttribute()
    {
        if (auth()->check() && $this->expiry_date != '') {
            $auth_country = \App\Models\CompanyAddress::select('countries.*')
                ->leftjoin('countries', 'countries.id', 'companies_addresses.country_id')
                ->where('companies_addresses.company_id', \Auth::user()->company_id)
                ->first();

            $auth_currency = isset($auth_country) && isset($auth_country->currency_symbol)
                ? $auth_country->currency_symbol
                : 'USD';

            $auth_format = isset($auth_country) && isset($auth_country->formats)
                ? $auth_country->formats
                : 'm-d-Y';
            return date($auth_format, strtotime($this->expiry_date));
        }
        return '';
    }

    public function getFileUrlAttribute()
    {
        if ($this->file_name != '') {
            return getTempUrl($this->file_name);
        }

        return '';
    }
}
