<?php

namespace App\Models;

use App\Helpers\SiteHelper;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccountLicense extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];
    protected $casts = [
        'license_number' => 'array', // or 'json'
    ];
    protected $appends = ['valid_from_formatted', 'valid_upto_formatted'];

    public function license_type()
    {
        return $this->belongsTo(LicenseType::class);
    }

    public function getValidFromFormattedAttribute()
    {
        return SiteHelper::reformatReadableDate($this->valid_from);
    }

    public function getValidUptoFormattedAttribute()
    {
        return SiteHelper::reformatReadableDate($this->valid_upto);
    }
    public function getAccounts()
    {
        return $this->belongsTo(Account::class,'primary_account');
    }

}
