<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Database\Eloquent\Model;
use App\Models\FinancialYear;
use App\Models\Purchase\PurchaseInvoices;

class AccountTransaction extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'transactions_no',
        'transaction_date',
        'module_code',
        'voucher_id',
        'batch_id',
        'voucher_sub_id',
        'voucher_type',
        'account_id',
        'transaction_type',
        'details_narration',
        'amount',
        'currency_id',
        'created_by',
        'company_id',
        'financial_year_id',
        'transactions_status',
        'last_id'
    ];
 
    public function Module(){
        return $this->belongsTo(MenuModelPermission::class,'module_code','code');
    }

    public function VoucherType(){
        return $this->hasOne(VoucherType::class,'code','voucher_type')->with('voucherMaster');
    }

    public function Account(){
        return $this->hasOne(Account::class,'id','account_id')->with('account_contact');
    }

    public function CreatedBy(){
        return $this->hasOne(Account::class,'id','created_by')->with('account_contact');
    }

    public function CreditTransaction(){
        return $this->hasMany(AccountTransaction::class,'transactions_no','transactions_no')
            ->where('transaction_type','CREDIT')
            ->with('VoucherType')
            ->with('Account');
    }

    public function DebitTransaction(){
        return $this->hasMany(AccountTransaction::class,'transactions_no','transactions_no')
            ->where('transaction_type','DEBIT')
            ->with('VoucherType')
            ->with('Account');
    }

    static public function createTransaction($data = []){

        if (!empty($data)) {
            $currency   = Company::companyCurrencyCode();
            $company_id = \Auth::user()->company_id ?? '';
            $created_by = \Auth::id() ?? '';

            $data['currency_id']         = ($currency->id ?? '');
            $data['created_by']          = $created_by;
            $data['company_id']          = $company_id;
            $data['transactions_status'] = '1';

            return self::create($data);
        }
    }

    static public function updateTransaction($where = [], $data = []){
        if (!empty($data)) {
            $transaction = self::where($where)->first();

            if ($transaction) {
                $transaction->update($data);

                return $transaction;
            } else {
                $currency       = Company::companyCurrencyCode();
                $company_id     = \Auth::user()->company_id ?? '';
                $created_by     = \Auth::id() ?? '';

                $data['currency_id']         = ($currency->id ?? '');
                $data['created_by']          = $created_by;
                $data['company_id']          = $company_id;
                $data['transactions_status'] = '1';

            self::insert(array_merge($where, $data));

            $transaction = self::where($where)->first();

                return $transaction;
            }
        }
    }

    public function contraVoucher(){
        return $this->hasOne(ContraVoucher::class,'id','voucher_id');
    }

    public function paymentVoucher(){
        return $this->hasOne(PaymentVoucher::class,'id','voucher_id');
    }

    public function journalVoucher(){
        return $this->hasOne(AcJournal::class,'id','voucher_id');
    }

    public function receiptVoucher(){
        return $this->hasOne(AcReceipt::class,'id','voucher_id');
    }

    public function pathologyVoucher(){
        return $this->hasOne(SaleInvoice::class,'id','voucher_id');
    }

    public function OpdVoucher(){
        return $this->hasOne(OpdBookings::class,'id','voucher_id');
    }

    public function IPDAdmissionVoucher(){
        return $this->hasOne(SaleInvoice::class,'id','voucher_id');
    }
    public function SalesVoucher(){
        return $this->hasOne(SaleInvoice::class,'id','voucher_id');
    }
    public function PurchaseVoucher(){
        return $this->hasOne(PurchaseInvoices::class,'id','voucher_id');
    }
}
