<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccountingGroup extends Model
{
    use HasFactory,SoftDeletes;

    protected $guarded = [];
    protected $table   = "accounting_groups";

    public function chart_Of_account_type()
    {
        return $this->belongsTo(ChartOfAccountType::class,'accounting_type_id');
    }

    public function paymentModes()
    {
        return $this->hasMany(PaymentMode::class,'accounting_group_id');
    }

    public function chart_of_expanses()
    {
        return $this->hasMany(Account::class, 'accounting_group_id');
    }

    public function accounts()
    {
        return $this->hasMany(Account::class, 'accounting_group_id')->select(['accounting_group_id','id','name']);
    }


}
