<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AccountingType extends Model
{
    use HasFactory,SoftDeletes;

    protected $fillable = [
        'name',
        'code',
        'if_increase',
        'if_decrease',
        'priority',
        'status',
        'is_default',
    ];

    protected $table = "accounting_types";

    public function chart_of_account_subType()
    {
        return $this->hasMany(AccountingGroup::class);
    }

    public function chart_of_account()
    {
        return $this->hasMany(ChartOfAccount::class);
    }
}
