<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AdvanceSetting extends Model
{
    use HasFactory;

    protected $fillable = [
        'master_setting_id',
        'voucher_master_id',
        'voucher_type_id',
        'value'
    ];

    public function master_setting()
    {
          return $this->belongsTo(MasterSetting::class,'master_setting_id');
    }

    static public function decimalPoint()
    {
        $decimal = self::where('master_setting_id', 1)->first();

        return $decimal->value ?? '2';
    }
}
