<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AppointmentDoctorFees extends Model
{
    use HasFactory;
    use SoftDeletes;
    protected $fillable = [
        'doctor_id',
        'shift_id',
        'product_id',
        'chamber_id',
        'status'
    ];
    public function getProduct()
    {
        return $this->belongsTo(Product::class,'product_id');
    }
    public function getDoctor()
    {
        return $this->belongsTo(Doctor::class,'doctor_id')->with('getAccount');
    }
    public function getProductPrice()
    {
        return $this->belongsTo(ProductPrice::class,'product_id','product_id');
    }
}
