<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AppointmentDoctorSchedule extends Model
{
    use HasFactory;
    protected $guarded = [];
    public function getDoctor()
    {
          return $this->belongsTo(Doctor::class,'doctor_id')->with('getAccount');
    }
    public function getType()
    {
          return $this->belongsTo(OpdScheduleType::class,'type');
    }
    public function getShift()
    {
          return $this->belongsTo(AppointmentShift::class,'shift_id');
    }
}
