<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AppointmentDoctorShift extends Model
{
    use HasFactory;

    protected $fillable = [
        'doctor_id',
        'shift_id',
        'status',
        'web_booking',
        'app_booking',
        'patient_quantity',
        'time_from',
        'time_to',
        'chamber_id',
        'serial_start'
    ];
    public function getDoctor()
    {
        return $this->belongsTo(Doctor::class,'doctor_id')->with('getAccount');
    }
    public function getShifts()
    {
        return $this->belongsTo(AppointmentShift::class,'shift_id');
    }
}
