<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AppointmentDoctorShiftDay extends Model
{
    use HasFactory;
    protected $primaryKey = 'id';
    protected $fillable = [
        'doctor_id',
        'shift_id',
        'day_id',
        'status',
        'chamber_id',
    ];
    public function getDoctor()
    {
        return $this->belongsTo(Doctor::class, 'doctor_id');
    }
    public function getShiftNames()
    {
        return $this->belongsTo(AppointmentShift::class,'shift_id');
    }
}
