<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use App\Exports\BedStatementExport;

class Bed extends Model
{
    use HasFactory;

    protected $guarded = [];

    public function getBedType()
    {
        return $this->belongsTo(BedType::class, 'bed_type_id');
    }

    public function getBedGroup()
    {
        return $this->belongsTo(BedGroup::class, 'bed_group_id');
    }

    public function getFloor()
    {
        return $this->belongsTo(Floor::class, 'floor_id');
    }

    public function getBuilding()
    {
        return $this->belongsTo(Building::class, 'building_id');
    }

    public function getRoom()
    {
        return $this->belongsTo(Room::class, 'room_id');
    }

    public function getIpdAdmission()
    {
        return $this->belongsTo(IpdAdmission::class, 'ipd_admission_no');
    }

    public static function getStatement($where = [], $filter = [])
    {
        $data = Bed::select([
            'beds.id as bed_id',
            'beds.name as bed_name',
            'beds.company_id',
            'beds.room_id',
            'beds.bed_type_id',
            'beds.bed_group_id',
            'beds.floor_id',
            'beds.building_id',
            'beds.bed_available',
            'beds.note',
            'beds.priority',
            'beds.ipd_admission_no',
            'beds.status',
            'beds.waiting_ipd_admission_id',
            'bed_groups.name as bed_group_name',
            'ipd_bed_histories.revert_reason as revert_reason',
            'ipd_bed_histories.check_in_date_time as check_in_date_time',
            'ipd_bed_histories.check_out_date_time as check_out_date_time',
            'bed_groups.is_active as active',
            'beds.status as bed_status',
            'bed_types.name as bed_type',
        ])
            ->leftJoin('bed_groups', 'bed_groups.id', '=', 'beds.bed_group_id')
            ->leftJoin('bed_types', 'bed_types.id', '=', 'beds.bed_type_id')
            ->leftJoin('ipd_bed_histories', function ($join) {
                $join->on('bed_groups.id', '=', 'ipd_bed_histories.bed_group_id')
                     ->where('bed_groups.is_active', '1');
            })
            ->when(!empty($filter['from_date']) && !empty($filter['to_date']), function ($query) use ($filter) {
                $query->when($filter['from_date'] == $filter['to_date'], function ($query) use ($filter) {
                    // Handle same day condition if needed
                })
                ->when($filter['from_date'] != $filter['to_date'], function ($query) use ($filter) {
                    $query->whereBetween('ipd_bed_histories.check_in_date_time', [$filter['from_date'], $filter['to_date']]);
                });
            })
            ->when(!empty($where), function ($query) use ($where) {
                $query->where($where);
            })
            ->when(!empty($filter['search_bed']), function ($query) use ($filter) {
                $query->where(function ($query) use ($filter) {
                    $query->where('beds.name', 'LIKE', '%' . $filter['search_bed'] . '%');
                });
            })
            ->when(!empty($filter['search_bed_status']), function ($query) use ($filter) {
                if($filter['search_bed_status'] == 'booked'){
                    $query->where('bed_groups.is_active', '0');
                }
                else if($filter['search_bed_status'] == 'available'){
                    $query->where('bed_groups.is_active', '1');
                }
            })
            ->when(!empty($filter['search_bed_group']), function ($query) use ($filter) {
                $query->where(function ($query) use ($filter) {
                    $query->where('bed_groups.id',  $filter['search_bed_group'] );
                });
            })
            ->when(!empty($filter['search_bed_type']), function ($query) use ($filter) {
                $query->where(function ($query) use ($filter) {
                    $query->where('bed_types.id' ,  $filter['search_bed_type'] );
                });
            })
            ->groupBy('beds.id')
            ->get();

        return $data;
    }
}
