<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class BirthRegister extends Model
{
    use HasFactory;

    protected $fillable = [
        'ipd_id',
        'child_name',
        'child_image',
        'gender_id',
        'birth_date',
        'birth_time',
        'weight',
        'mother_name',
        'mother_image',
        'father_name',
        'father_image',
        'contact',
        'birth_report',
        'document',
        'present_address',
        'permanent_address',
        'is_active',
    ];


    static public function getStatement($where = [], $filter = []) 
    {

        $data = BirthRegister::select([
                'birth_registers.id',
                'birth_registers.ipd_id',
                'ipd_admissions.ipd_admission_no as case_id',
                'birth_registers.child_name as child_name',
                'birth_registers.gender_id as gender_id',
                'genders.name as gender_name',
                'birth_registers.birth_date as birth_date',
                'birth_registers.birth_time as birth_time',
                'birth_registers.mother_name as mother_name',
                'birth_registers.father_name as father_name',
                'birth_registers.birth_report as birth_report',
                'genders.id',
                'ipd_admissions.id as ipd_admission_id',
                'ipd_discharges.id',

        ])
        ->leftJoin('ipd_admissions', 'ipd_admissions.id', '=', 'birth_registers.ipd_id')
        ->leftJoin('genders', 'genders.id', '=', 'birth_registers.gender_id')
        ->leftJoin('ipd_discharges', 'ipd_discharges.ipd_admission_id', '=', 'ipd_admissions.id')
        ->leftJoin('accounts', 'accounts.id', '=', 'ipd_admissions.patient_id')
        ->leftJoin('companies', 'companies.id', '=', 'accounts.company_id')
        ->when(!empty($where), function($query) use ($where) {
            $query->where($where);
        })
       ->when(!empty($filter['from_date']) && !empty($filter['to_date']), function($query) use ($filter) {
            $query->when($filter['from_date'] == $filter['to_date'], function($query) use ($filter) {
            })
            ->when($filter['from_date'] != $filter['to_date'], function($query) use ($filter) {
                $query->whereBetween('ipd_admissions.admission_date_time', [$filter['from_date'], $filter['to_date']]);
            });
        })
        ->when(!empty($filter['search_account']), function($query) use ($filter) {
            $query->where(function($query) use ($filter) {
                $query->where('accounts.name', 'LIKE', '%' . $filter['search_account'] . '%');
            });
        })
        ->when(!empty($filter['company']), function($query) use ($filter) {
            $query->where('accounts.company_id', $filter['company']);
        })
        ->when(!empty($filter['listing_type']), function($query) use ($filter){
            if ($filter['listing_type'] == 'active') {
            $query->whereNull('ipd_discharges.id');
        } elseif ($filter['listing_type'] == 'discharged') {
            $query->whereNotNull('ipd_discharges.id');
        }
        })
        ->groupBy('ipd_admissions.id')
        ->get();

        return $data;
    }

}
