<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class BodyVital extends Model
{
    use HasFactory, SoftDeletes;

    protected $guarded = [];

    public function get_vital_histories()
    {
        return $this->hasMany(IpdBodyVitalHistory::class, 'body_vital_id');
    }

    public function edit_vital_histories()
    {
        return $this->hasOne(IpdBodyVitalHistory::class, 'body_vital_id');
    }
}
