<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\LibrarySetting\BookClass;
use App\Models\LibrarySetting\Translators;
use App\Models\LibrarySetting\LibrarianTags;
use App\Models\LibrarySetting\LibrarianAuthors;
use App\Models\LibrarySetting\LibrarianPublishers;
use App\Models\LibrarySetting\LibrarianBookLanguages;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class BookDetails extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $appends = ['author', 'publisher', 'translator', 'laguage', 'book_class', 'book_tag'];
    protected $fillable = [
        'book_id',
        'book_format_id',
        'edition',
        'editor',
        'print_year',
        'released_date',
        'price',
        'no_of_pages',
        'author_id',
        'publisher_id',
        'stream_id',
        'translator_id',
        'laguages_id',
        'book_class_id',
        'book_tag_id',
        'book_url',
        'dimensions'
    ];

    public function getAuthorAttribute()
    {
        $author = LibrarianAuthors::find($this->author_id);
        return isset($author->first_name) ? $author->first_name . ' ' . $author->last_name : '';
    }

    public function getPublisherAttribute()
    {
        $publisher = LibrarianPublishers::find($this->publisher_id);
        return isset($publisher->name) ? $publisher->name : '';
    }

    public function getTranslatorAttribute()
    {
        $translator = Translators::find($this->translator_id);
        return isset($translator->translator_name) ? $translator->translator_name : '';
    }

    public function getLaguageAttribute()
    {
        $laguage = Language::find($this->laguages_id);
        return isset($laguage->name) ? $laguage->name : '';
    }

    public function getBookClassAttribute()
    {
        $class = BookClass::find($this->book_class_id);
        return isset($class->class_name) ? $class->class_name : '';
    }

    public function getBookTagAttribute()
    {
        $tag = LibrarianTags::find($this->book_tag_id);
        return isset($tag->tag_name) ? $tag->tag_name : '';
    }
}
